<?php

namespace App\Form;

use App\Form\EntityToIdTransformer;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class HiddenEntityExtension extends AbstractTypeExtension
{
    public static function getExtendedTypes()
    {
        return array(HiddenType::class);
    }

    /**
     * Add the entity_class option
     *
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefined(array('em'));
        $resolver->setDefined(array('entity_class'));
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        if (isset($options['em'])&&isset($options['entity_class'])) {
            $builder->addModelTransformer(new EntityToIdTransformer(
                $options['em'],
                $options['entity_class']
            ));
        }
    }
}
