<?php

namespace App\Controller;

use App\Entity\Groupeprestataire;
use App\Entity\Prestataire;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

/**
 * LOCO : Outil de gestion de Monnaie Locale Complémentaire
 *
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class GroupePrestaController extends AbstractController
{
    private $em;

    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * @Route("/prestataires/groupe/{type}/{slug}", name="show_groupeprestataire")
     */
    public function showGroupeAction(Groupeprestataire $groupe)
    {
        return $this->render('groupepresta/show.html.twig', array(
            'groupe' => $groupe
        ));
    }

    /**
     * @Route("/groupe/prestataires/{type}/liste", name="groupepresta_liste")
     */
    public function listeGroupePrestaAction($type, Request $request)
    {
        $groupe = $this->em->getRepository(Groupeprestataire::class)->findBy(array('type' => $type, 'enabled' => true), array('name'=> 'ASC'));

        return $this->render('groupepresta/liste.html.twig', array(
            'groupes' => $groupes,
            'groupetype' => $type
        ));
    }

    /**
     * @Route("/groupe/prestataires/{type}/carte", name="groupepresta_carte")
     */
    public function carteGroupePrestaAction($type, Request $request)
    {
        $groupes = $this->em->getRepository(Groupeprestataire::class)->findBy(array('type' => $type, 'enabled' => true));

        return $this->render('groupepresta/carte.html.twig', array(
            'groupes' => $groupes,
            'groupetype' => $type
        ));
    }
}
