<?php
namespace App\Tests;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

class ApplicationAvailabilityFunctionalTest extends WebTestCase
{
    /**
     * @dataProvider urlProvider
     */
    public function testPageIsSuccessful($url)
    {
        $client = static::createClient([]);
        $client->request('GET', $url);

        $this->assertTrue($client->getResponse()->isSuccessful());
    }

    public function urlProvider()
    {
        yield ['/'];
        yield ['/adherer'];
        yield ['/news'];
        yield ['/faq'];
        yield ['/contact'];
        yield ['/login'];
        yield ['/prestataires/liste'];
        yield ['/prestataires/carte'];
        yield ['/prestataires/rubriques'];
        yield ['/partenaires/liste'];
        yield ['/comptoirs/liste'];
        yield ['/comptoirs/carte'];
        yield ['/groupe/prestataires/amap/carte'];
        yield ['/groupe/prestataires/marche/carte'];
        yield ['/resetting/request'];
    }

    /**
     * @dataProvider adminUrlProvider
     */
    public function testADMINPageIsSuccessful($url)
    {
        $client = static::createClient([], [
            'PHP_AUTH_USER' => 'julien.jorry@gmail.com',
            'PHP_AUTH_PW'   => 'test',
        ]);
        $client->request('GET', $url);

        $this->assertTrue($client->getResponse()->isSuccessful());
    }

    public function adminUrlProvider()
    {
        yield ['/'];
        yield ['/admin/dashboard'];
        yield ['/admin/app/user/list'];
        yield ['/admin/app/user/create'];
        yield ['/admin/app/usergroup/list'];
        yield ['/admin/adherent/list'];
        yield ['/admin/adherent/create'];
        yield ['/admin/cotisation_adherent/list'];
        yield ['/admin/prestataire/list'];
        yield ['/admin/prestataire/create'];
        yield ['/admin/cotisation_prestataire/list'];
        yield ['/admin/cotisation_prestataire/create'];
        yield ['/admin/app/groupeprestataire/list'];
        yield ['/admin/app/groupeprestataire/create'];
        yield ['/admin/app/groupe/list'];
        yield ['/admin/app/groupe/create'];
        yield ['/admin/app/comptoir/list'];
        yield ['/admin/app/comptoir/create'];
        yield ['/admin/app/news/list'];
        yield ['/admin/app/news/create'];
        yield ['/admin/app/document/list'];
        yield ['/admin/app/document/create'];
        yield ['/admin/app/page/list'];
        yield ['/admin/app/page/create'];
        yield ['/admin/app/rubrique/list'];
        yield ['/admin/app/rubrique/create'];
        yield ['/admin/app/faq/list'];
        yield ['/admin/app/faq/create'];
        yield ['/admin/translations/list'];
        yield ['/admin/app/flux/list'];
        yield ['/admin/cotisation/list'];
        yield ['/admin/cotisation/create'];
        yield ['/admin/app/transfert/list'];
        yield ['/admin/app/transaction/list'];
        yield ['/admin/app/transfertprestatairesiege/list'];
        yield ['/admin/sonata/menu/list'];
        yield ['/admin/sonata/menu/create'];

    }

}
