<?php

namespace App\Twig;

use App\Entity\Flux;
use App\Entity\Groupe;
use App\Entity\Rubrique;
use App\Entity\User;
use App\Factory\FormFactory;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;
use Twig\TwigTest;

class FormExtension extends AbstractExtension
{
    public $container;

    public function __construct($container)
    {
        $this->container = $container;
    }

    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction('getUserInfosForm', array($this, 'getUserInfosForm')),
            new \Twig_SimpleFunction('getUserPasswordForm', array($this, 'getUserPasswordForm')),
            new \Twig_SimpleFunction('getGroupeInfosForm', array($this, 'getGroupeInfosForm')),
            new \Twig_SimpleFunction('getComptoirInfosForm', array($this, 'getComptoirInfosForm')),
            new \Twig_SimpleFunction('getPrestataireInfosForm', array($this, 'getPrestataireInfosForm')),
            new \Twig_SimpleFunction('getAdherentInfosForm', array($this, 'getAdherentInfosForm')),
            new \Twig_SimpleFunction('getGroupePrestataireInscriptionForm', array($this, 'getGroupePrestataireInscriptionForm')),
            new \Twig_SimpleFunction('getTransactionAdherentAdherentForm', array($this, 'getTransactionAdherentAdherentForm')),
            new \Twig_SimpleFunction('getTransactionAdherentPrestataireForm', array($this, 'getTransactionAdherentPrestataireForm')),
            new \Twig_SimpleFunction('getTransactionPrestataireAdherentForm', array($this, 'getTransactionPrestataireAdherentForm')),
            new \Twig_SimpleFunction('getTransactionPrestatairePrestataireForm', array($this, 'getTransactionPrestatairePrestataireForm')),
            new \Twig_SimpleFunction('getTransfertPrestataireSiegeForm', array($this, 'getTransfertPrestataireSiegeForm')),
            new \Twig_SimpleFunction('getTransfertPrestataireComptoirForm', array($this, 'getTransfertPrestataireComptoirForm')),
            new \Twig_SimpleFunction('getTransfertComptoirToXForm', array($this, 'getTransfertComptoirToXForm')),
            new \Twig_SimpleFunction('getTransfertGroupeComptoirForm', array($this, 'getTransfertGroupeComptoirForm')),
            new \Twig_SimpleFunction('getTransfertSiegeGroupeForm', array($this, 'getTransfertSiegeGroupeForm')),
            new \Twig_SimpleFunction('getTransfertGroupeSiegeForm', array($this, 'getTransfertGroupeSiegeForm')),
        ];
    }

    public function getPrestataireInfosForm(User $user)
    {
        return $this->container->get('app.formfactory')->getPrestataireInfosForm($user);
    }
    public function getAdherentInfosForm(User $user)
    {
        return $this->container->get('app.formfactory')->getAdherentInfosForm($user);
    }
    public function getUserInfosForm(User $user)
    {
        return $this->container->get('app.formfactory')->getUserInfosForm($user);
    }
    public function getUserPasswordForm(User $user)
    {
        return $this->container->get('app.formfactory')->getUserPasswordForm($user);
    }
    public function getGroupeInfosForm(User $user)
    {
        return $this->container->get('app.formfactory')->getGroupeInfosForm($user);
    }
    public function getComptoirInfosForm(User $user)
    {
        return $this->container->get('app.formfactory')->getComptoirInfosForm($user);
    }
    public function getGroupePrestataireInscriptionForm(User $user)
    {
        return $this->container->get('app.formfactory')->getGroupePrestataireInscriptionForm($user);
    }
    public function getTransactionAdherentAdherentForm(User $user)
    {
        return $this->container->get('app.formfactory')->getTransactionAdherentAdherentForm($user);
    }
    public function getTransactionAdherentPrestataireForm(User $user)
    {
        return $this->container->get('app.formfactory')->getTransactionAdherentPrestataireForm($user);
    }
    public function getTransactionPrestataireAdherentForm(User $user)
    {
        return $this->container->get('app.formfactory')->getTransactionPrestataireAdherentForm($user);
    }
    public function getTransactionPrestatairePrestataireForm(User $user)
    {
        return $this->container->get('app.formfactory')->getTransactionPrestatairePrestataireForm($user);
    }
    public function getTransfertPrestataireSiegeForm(User $user)
    {
        return $this->container->get('app.formfactory')->getTransfertPrestataireSiegeForm($user);
    }
    public function getTransfertPrestataireComptoirForm(User $user)
    {
        return $this->container->get('app.formfactory')->getTransfertPrestataireComptoirForm($user);
    }
    public function getTransfertComptoirToXForm(User $user, $destinataire)
    {
        return $this->container->get('app.formfactory')->getTransfertComptoirToXForm($user, $destinataire);
    }
    public function getTransfertGroupeComptoirForm(User $user)
    {
        return $this->container->get('app.formfactory')->getTransfertGroupeComptoirForm($user);
    }
    public function getTransfertSiegeGroupeForm(User $user)
    {
        return $this->container->get('app.formfactory')->getTransfertSiegeGroupeForm($user);
    }
    public function getTransfertGroupeSiegeForm(User $user)
    {
        return $this->container->get('app.formfactory')->getTransfertGroupeSiegeForm($user);
    }
}
