<?php

namespace App\Form\Type;

use App\Entity\Cotisation;
use App\Enum\MoyenEnum;
use App\Form\Type\CotisationInfosFormType;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class AddCotisationFormType extends AbstractType
{
    protected $em;
    protected $security;

    public function __construct(EntityManagerInterface $em, Security $security)
    {
        $this->em = $em;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $now = new \DateTime();
        $flux = $options['data'];
        // dump($flux);
        // exit();
        if (empty($this->security) && !empty($this->security->getUser())) {
            throw new \Exception("Opération impossible ! Utilisateur déjà connecté !");
        }
        $builder
            ->add('type', HiddenType::class, array(
                'data' => 'cotisation',
                'data_class' => null
            ))
            ->add('operateur', HiddenType::class, array(
                'entity_class' => User::class,
                'em' => $this->em
            ))
            ->add('reference', HiddenType::class, array(
                'label' => 'Reference :',
                'required' => true,
                'data' => 'Cotisation '.$now->format('Y')
            ))
            ->add('montant', HiddenType::class, array(
            ))
            ->add('moyen', HiddenType::class, array(
                'data' => MoyenEnum::MOYEN_AUTRE,
            ))
            ;
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Cotisation::class,
            'cascade_validation' => true
        ));
    }

    public function getBlockPrefix()
    {
        return 'formAddCotisation';
    }
}
