<?php

namespace App\Factory;

use App\Entity\TransactionAdherentAdherent;
use App\Entity\TransactionAdherentPrestataire;
use App\Entity\TransactionComptoirAdherent;
use App\Entity\TransactionComptoirGroupe;
use App\Entity\TransactionComptoirPrestataire;
use App\Entity\TransactionPrestataireAdherent;
use App\Entity\TransactionPrestatairePrestataire;
use App\Entity\TransfertGroupeComptoir;
use App\Entity\TransfertGroupeSiege;
use App\Entity\TransfertPrestataireComptoir;
use App\Entity\TransfertPrestataireSiege;
use App\Entity\TransfertSiegeGroupe;
use App\Entity\User;
use App\Enum\MoyenEnum;
use App\Form\Type\AdherentInfosFormType;
use App\Form\Type\ComptoirInfosFormType;
use App\Form\Type\GroupeInfosFormType;
use App\Form\Type\GroupePrestataireInscriptionFormType;
use App\Form\Type\PrestataireInfosFormType;
use App\Form\Type\RegistrationFormType;
use App\Form\Type\TransactionAdherentAdherentFormType;
use App\Form\Type\TransactionAdherentPrestataireFormType;
use App\Form\Type\TransactionPrestataireAdherentFormType;
use App\Form\Type\TransactionPrestatairePrestataireFormType;
use App\Form\Type\TransfertGroupeComptoirFormType;
use App\Form\Type\TransfertGroupeSiegeFormType;
use App\Form\Type\TransfertPrestataireComptoirFormType;
use App\Form\Type\TransfertPrestataireSiegeFormType;
use App\Form\Type\TransfertSiegeGroupeFormType;
use App\Form\Type\UserInfosFormType;
use FOS\UserBundle\Form\Type\ChangePasswordFormType;
use Symfony\Component\Form\FormFactoryInterface as FormF;
use Symfony\Component\Routing\RouterInterface;

class FormFactory
{
    public $ff;
    public $router;

    public function __construct(FormF $ff, RouterInterface $router)
    {
        $this->ff = $ff;
        $this->router = $router;
    }

    public function getUserInfosForm(User $user)
    {
        if (empty($user)) {
            throw new \Exception("[FORM 0] Opération impossible !");
        }
        $form = $this->ff->create(UserInfosFormType::class, $user, array('action' => $this->router->generate('user_infos')));

        return $form->createView();
    }

    public function getUserPasswordForm(User $user)
    {
        if (empty($user)) {
            throw new \Exception("[FORM 1] Opération impossible !");
        }
        $form = $this->ff->create(ChangePasswordFormType::class, $user, array('action' => $this->router->generate('fos_user_change_password')));

        return $form->createView();
    }

    public function getGroupeInfosForm(User $user)
    {
        if (empty($user) || empty($user->getGroupesgere())) {
            throw new \Exception("[FORM 2] Opération impossible !");
        }
        $form = $this->ff->create(GroupeInfosFormType::class, $user->getGroupesgere(), array('action' => $this->router->generate('groupe_infos')));

        return $form->createView();
    }

    public function getComptoirInfosForm(User $user)
    {
        if (empty($user) || empty($user->getComptoirsgere())) {
            throw new \Exception("[FORM 3] Opération impossible !");
        }
        $form = $this->ff->create(ComptoirInfosFormType::class, $user->getComptoirsgere(), array('action' => $this->router->generate('comptoir_infos')));

        return $form->createView();
    }

    public function getPrestataireInfosForm(User $user)
    {
        if (empty($user) || empty($user->getPrestataire())) {
            throw new \Exception("[FORM 4] Opération impossible !");
        }
        $form = $this->ff->create(PrestataireInfosFormType::class, $user->getPrestataire(), array('action' => $this->router->generate('prestataire_infos')));

        return $form->createView();
    }

    public function getAdherentInfosForm(User $user)
    {
        if (empty($user) || empty($user->getAdherent())) {
            throw new \Exception("[FORM 5] Opération impossible !");
        }
        $form = $this->ff->create(AdherentInfosFormType::class, $user->getAdherent(), array('action' => $this->router->generate('adherent_infos')));

        return $form->createView();
    }

    public function getGroupePrestataireInscriptionForm(User $user)
    {
        if (empty($user) || empty($user->getPrestataire())) {
            throw new \Exception("[FORM 6] Opération impossible !");
        }
        $form = $this->ff->create(GroupePrestataireInscriptionFormType::class, $user->getPrestataire(), array('action' => $this->router->generate('groupeprestataire_inscription')));

        return $form->createView();
    }

    public function getTransactionAdherentAdherentForm(User $user)
    {
        if (empty($user) || empty($user->getAdherent())) {
            throw new \Exception("[FORM 7] Opération impossible !");
        }
        $entity = new TransactionAdherentAdherent();
        $entity->setOperateur($user);
        $entity->setExpediteur($user->getAdherent());
        $form = $this->ff->create(TransactionAdherentAdherentFormType::class, $entity, array('action' => $this->router->generate('transactionAdherentAdherent')));

        return $form->createView();
    }

    public function getTransactionAdherentPrestataireForm(User $user)
    {
        if (empty($user) || empty($user->getAdherent())) {
            throw new \Exception("[FORM 8] Opération impossible !");
        }
        $entity = new TransactionAdherentPrestataire();
        $entity->setOperateur($user);
        $entity->setExpediteur($user->getAdherent());
        $form = $this->ff->create(TransactionAdherentPrestataireFormType::class, $entity, array('action' => $this->router->generate('transactionAdherentPrestataire')));

        return $form->createView();
    }

    public function getTransactionPrestataireAdherentForm(User $user)
    {
        if (empty($user) || empty($user->getPrestataire())) {
            throw new \Exception("[FORM] Opération impossible !");
        }
        $entity = new TransactionPrestataireAdherent();
        $entity->setOperateur($user);
        $entity->setExpediteur($user->getPrestataire());
        $form = $this->ff->create(TransactionPrestataireAdherentFormType::class, $entity, array('action' => $this->router->generate('transactionPrestataireAdherent')));

        return $form->createView();
    }

    public function getTransactionPrestatairePrestataireForm(User $user)
    {
        if (empty($user) || empty($user->getPrestataire())) {
            throw new \Exception("[FORM 9] Opération impossible !");
        }
        $entity = new TransactionPrestatairePrestataire();
        $entity->setOperateur($user);
        $entity->setExpediteur($user->getPrestataire());
        $form = $this->ff->create(TransactionPrestatairePrestataireFormType::class, $entity, array('action' => $this->router->generate('transactionPrestatairePrestataire')));

        return $form->createView();
    }

    public function getTransfertPrestataireSiegeForm(User $user)
    {
        if (empty($user) || empty($user->getPrestataire())) {
            throw new \Exception("[FORM 10] Opération impossible !");
        }
        $entity = new TransfertPrestataireSiege();
        $entity->setExpediteur($user->getPrestataire());
        $form = $this->ff->create(TransfertPrestataireSiegeFormType::class, $entity, array('action' => $this->router->generate('transactionPrestataireSiege')));

        return $form->createView();
    }

    public function getTransfertPrestataireComptoirForm(User $user)
    {
        if (empty($user) || empty($user->getComptoirsgere())) {
            throw new \Exception("[FORM 11] Opération impossible !");
        }
        $entity = new TransfertPrestataireComptoir();
        $entity->setDestinataire($user->getComptoirsgere());
        $form = $this->ff->create(TransfertPrestataireComptoirFormType::class, $entity, array('action' => $this->router->generate('transfertPrestataireComptoir')));

        return $form->createView();
    }

    public function getTransfertComptoirToXForm(User $user, $type)
    {
        $type = strtolower($type);
        if (empty($user) || empty($user->getComptoirsgere()) || !($type == 'adherent' || $type == 'groupe' || $type == 'prestataire')) {
            throw new \Exception("[FORM 12] Opération impossible !");
        }
        $class = "App\Entity\TransfertComptoir".ucwords($type);
        $entity = new $class();
        $entity->setOperateur($user);
        $entity->setExpediteur($user->getComptoirsgere());
        $form = $this->ff->create('App\Form\Type\TransfertComptoir'.ucwords($type).'FormType', $entity, array('action' => $this->router->generate('transfertComptoir'.ucwords($type))));

        return $form->createView();
    }

    public function getTransfertGroupeComptoirForm(User $user)
    {
        if (empty($user) || empty($user->getGroupesgere())) {
            throw new \Exception("[FORM 13] Opération impossible !");
        }
        $entity = new TransfertGroupeComptoir();
        $entity->setOperateur($user);
        $entity->setExpediteur($user->getGroupesgere());
        $form = $this->ff->create(TransfertGroupeComptoirFormType::class, $entity, array('action' => $this->router->generate('transfertGroupeComptoir')));

        return $form->createView();
    }

    public function getTransfertSiegeGroupeForm(User $user)
    {
        if (empty($user) || !$user->hasRole('ROLE_ADMIN_SIEGE')) {
            throw new \Exception("[FORM 14] Opération impossible !");
        }
        $entity = new TransfertSiegeGroupe();
        $entity->setOperateur($user);
        $form = $this->ff->create(TransfertSiegeGroupeFormType::class, $entity, array('action' => $this->router->generate('transfertSiegeGroupe')));

        return $form->createView();
    }

    public function getTransfertGroupeSiegeForm(User $user)
    {
        if (empty($user) || !$user->hasRole('ROLE_ADMIN_SIEGE')) {
            throw new \Exception("[FORM 15] Opération impossible !");
        }
        $entity = new TransfertGroupeSiege();
        $entity->setOperateur($user);
        $form = $this->ff->create(TransfertGroupeSiegeFormType::class, $entity, array('action' => $this->router->generate('transfertGroupeSiege')));

        return $form->createView();
    }
}
