<?php

namespace App\Form\Type;

use App\Entity\User;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormError;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class UserInfosFormType extends AbstractType
{
    protected $em;

    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->remove('username')
            ->add('firstname', TextType::class, array(
                'label' => 'Prénom',
                'required' => false,
            ))
            ->add('lastname', TextType::class, array(
                'label' => 'Nom',
                'required' => false,
            ))
            ->add('email', EmailType::class, array(
                'label' => 'Courriel',
                'required' => true,
                'disabled' => true,
                'translation_domain' => 'FOSUserBundle'
            ))
            ->add('alertemailflux', CheckboxType::class, ['label' => "Alertes email à chaque transaction ?"])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => User::class,
            'cascade_validation' => true,
            // 'type' => null
        ));
    }

    public function getBlockPrefix()
    {
        return 'user_infos';
    }
}
