<?php

namespace App\Form\Type;

use App\Entity\Siege;
use App\Entity\Groupe;
use App\Entity\GlobalParameter;
use Doctrine\ORM\EntityManagerInterface;
use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\Email as EmailConstraint;
use Symfony\Component\Validator\Constraints\Type as TypeConstraint;
use Symfony\Component\Validator\Constraints\Regex as RegexConstraint;

class GlobalConfigurationFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('mlcname', GlobalParameterType::class, array(
                'label' => 'Nom de la Monnaie (long) :',
                'name_param' => GlobalParameter::MLC_NAME,
                '_placeholder' => 'Monnaie Locale Complémentaire',
                'required' => true,
            ))
            ->add('mlcsmallname', GlobalParameterType::class, array(
                'label' => 'Nom court de la Monnaie ou abbréviation :',
                'name_param' => GlobalParameter::MLC_NAME_SMALL,
                '_placeholder' => 'MLC',
                'required' => true,
            ))
            ->add('mlcnotifemail', GlobalParameterType::class, array(
                'label' => "Email utilisé pour l'envoi des notifications :",
                'name_param' => GlobalParameter::MLC_NOTIF_EMAIL,
                'required' => true,
                '_placeholder' => 'notification@votredomaine.fr',
                'constraints_param' => [
                    new EmailConstraint(['message' => 'Email invalide !'])
                ],
            ))
            ->add('mlccontactemail', GlobalParameterType::class, array(
                'label' => "Email de reception des demandes de contact :",
                'name_param' => GlobalParameter::MLC_CONTACT_EMAIL,
                'required' => true,
                '_placeholder' => 'contact@votredomaine.fr',
                'constraints_param' => [
                    new EmailConstraint(['message' => 'Email invalide !'])
                ],
            ))
            ->add('mlccotisationadh', GlobalParameterType::class, array(
                'label' => 'Montant par défaut des cotisations des adhérents :',
                'name_param' => GlobalParameter::COTISATION_ADHERENT,
                'help' => 'Ne pas utiliser de virgule ",", utiliser le point "."',
                'required' => true,
                '_placeholder' => '10',
                'constraints_param' => [
                    new TypeConstraint(['type' => 'numeric', 'message' => "Le montant n'est pas valide !"])
                ],
            ))
            ->add('mlccotisationpresta', GlobalParameterType::class, array(
                'label' => 'Montant par défaut des cotisations des prestataires :',
                'name_param' => GlobalParameter::COTISATION_PRESTATAIRE,
                'help' => 'Ne pas utiliser de virgule ",", utiliser le point "."',
                'required' => true,
                '_placeholder' => '10',
                'constraints_param' => [
                    new TypeConstraint(['type' => 'numeric', 'message' => "Le montant n'est pas valide !"])
                ],
            ))
            ->add('mlcreconversionpresta', GlobalParameterType::class, array(
                'label' => 'Taux de reconversion des prestataires :',
                'name_param' => GlobalParameter::RECONVERSION_PRESTATAIRE,
                'help' => 'Ne pas utiliser de virgule ",", utiliser le point "."',
                'required' => true,
                '_placeholder' => '0',
                'constraints_param' => [
                    new TypeConstraint(['type' => 'numeric', 'message' => "Le montant n'est pas valide !"])
                ],
            ))
            ->add('mapcenter', GlobalParameterType::class, array(
                'label' => 'Coordonnées du centre de la carte (Format [lat,long], exemple : [45.7,3.2]):',
                'name_param' => GlobalParameter::MAP_CENTER,
                'required' => true,
                '_placeholder' => '[45.7,3.2]',
                'constraints_param' => [
                    new RegexConstraint(['pattern' => '/^\[[0-9]+\.[0-9]+,[0-9]+\.[0-9]+\]/', 'message' => 'Coordonnées invalide, format attendu : [45.7,3.2]'])
                ],
                'help_html' => true,
                'help' => "Pour déterminer le centre et zoom de la carte <a target='_blank' href='https://www.openstreetmap.org/'>Ouvrir OpenStreetMap</a><br/>
                            Exemple : <em>https://www.openstreetmap.org/search?query=clermont#map=12/45.7811/3.0927</em><br/>
                            Zoom de la carte   : 12<br/>
                            Centre de la carte : [45.7811,3.0927]"
            ))
            ->add('mapzoom', GlobalParameterType::class, array(
                'label' => 'Zoom de la carte (nombre entre 1 et 19) :',
                'name_param' => GlobalParameter::MAP_ZOOM,
                'required' => true,
                '_placeholder' => '9',
                'constraints_param' => [
                    new RegexConstraint(['pattern' => '/^[1-9]$|^1[0-9]$/', 'message' => 'Le zoom doit être un nombre entre 1 et 19, généralement entre 9 et 15 pour les MLC !'])
                ],
            ))
            // @TODO : checkbox au lieu de texttype pour certains paramètres globaux
            ->add('usewordpress', GlobalParameterType::class, array(
                'label' => "Utiliser Wordpress pour le site web :",
                'name_param' => GlobalParameter::USE_WORDPRESS,
                'required' => true,
                '_placeholder' => 'false',
                'constraints_param' => [
                    new RegexConstraint(['pattern' => '/^true$|^false$/', 'message' => 'La valeur doit être "true" ou "false"'])
                ],
                'help' => ''
            ))
            ->add('usepayzen', GlobalParameterType::class, array(
                'label' => "Utiliser le paiement par CB avec Payzen :",
                'name_param' => GlobalParameter::USE_PAYZEN,
                'required' => true,
                '_placeholder' => 'false',
                'constraints_param' => [
                    new RegexConstraint(['pattern' => '/^true$|^false$/', 'message' => 'La valeur doit être "true" ou "false"'])
                ],
                'help' => 'Si cette option est activée (true), les utilisateurs pourront cotiser et acheter de la monnaie locale par CB sur l\'application.'
            ))
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            // 'cascade_validation' => true
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formGlobalConfiguration';
    }
}
