<?php

namespace App\Form\Type;

use App\Entity\Comptoir;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class FirstComptoirFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('enabled', HiddenType::class, array('data' => true))
            ->add('name', TextType::class, array(
                'label' => 'Nom :',
                'required' => true,
                'help' => "Vous pourrez éditer la description dans l'interface d'administration"
            ))
            ->add('geoloc', GeolocFormType::class, array(
                'label' => 'Géolocalisation :',
                'attr' => ['class' => 'ml-4'],
                'required' => true
            ))
            ->add('compte', NumberType::class, array(
                'label' => 'Solde de monnaie papier actuellement au comptoir :',
                'required' => true
            ))
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Comptoir::class
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formFirstComptoir';
    }
}
