<?php

namespace App\Form\Type;

use App\Entity\ContactPrestataire;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Routing\RouterInterface;

class ContactPrestataireFormType extends AbstractType
{
    private $router;

    public function __construct(RouterInterface $router)
    {
        $this->router = $router;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $geoloc = null;
        if (!empty($options['data'])) {
            $geoloc = $options['data'];
        }
        $builder
            ->add('name', TextType::class, array(
                'label' => "Nom du contact / description :",
                'required' => true,
            ))
            ->add('tel', TextType::class, array(
                'label' => "Téléphone :",
                'required' => false,
            ))
            ->add('email', TextType::class, array(
                'label' => "Email :",
                'required' => false,
            ))
            ->add('enabled', CheckboxType::class, array(
                'label' => 'Public ?',
                'required' => false,
                'label_attr' => array('class' => 'checkbox-inline')
            ))
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        // $resolver->setRequired(['with_latlon']);
        $resolver->setDefaults([
            'data_class' => ContactPrestataire::class
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formContactPrestataire';
    }
}
