<?php

namespace App\Entity;

use App\Entity\GlobalParameter;
use App\Entity\Prestataire;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * COMMISSION
 *  - PRESTATAIRES      =>     PRESTATAIRE MLC                (Commission de Reconversion)
 *
 * @ORM\Entity()
 */
class CommissionPrestataireMLC extends Flux
{
    /**
     * @ORM\OneToOne(targetEntity="Prestataire")
     * @ORM\JoinColumn(name="prestataire_id", referencedColumnName="id")
     */
    protected $expediteur;

    /**
     * @ORM\OneToOne(targetEntity="Prestataire")
     * @ORM\JoinColumn(name="prestataire_dest_id", referencedColumnName="id")
     */
    protected $destinataire;

    /**
     * @return string
     */
    public function getParenttype(): string
    {
        return self::TYPE_COMMISSION;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'reconversion_prestataire';
    }

    public function operate($em)
    {
        return [];
    }

    public function getUsersToNotify()
    {
        return [];
    }
}
