<?php

namespace App\Block;

use Sonata\AdminBundle\Form\FormMapper;
use Sonata\BlockBundle\Block\AbstractBlockService;
use Sonata\BlockBundle\Block\BaseBlockService;
use Sonata\BlockBundle\Block\BlockContextInterface;
use Sonata\BlockBundle\Model\BlockInterface;
use Sonata\CoreBundle\Validator\ErrorElement;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\OptionsResolver\OptionsResolver;

class DashboardKohinosBlock extends AbstractBlockService
{
    /**
     * {@inheritdoc}
     */
    public function execute(BlockContextInterface $blockContext, Response $response = null)
    {
        // $end = new \DateTime();
        // $start = new \DateTime('7 days ago');

        // $chart = $this->chartBuilder->getRegistrationsChart($start, $end);

        return $this->renderResponse($blockContext->getTemplate(), array(
            // 'chart' =>  $chart,
            'block'  => $blockContext->getBlock(),
            'settings'  => $blockContext->getSettings(),
        ), $response);
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'Dashboard';
    }

    /**
     * {@inheritdoc}
     */
    public function configureSettings(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'title' => 'Dashboard',
            'summaries' => false,
            'template' => 'block/dashboard_kohinos.html.twig',
        ));
    }
}
