<?php

namespace App\Security\Voter;

use App\Entity\User;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\Authorization\AccessDecisionManagerInterface;
use Symfony\Component\Security\Core\Authorization\Voter\Voter;

class UserVoter extends Voter
{
    const ADD = 'add';
    const GET = 'get';
    const EDIT = 'edit';
    const LIST = 'list';
    const REMOVE = 'remove';

    private $decisionManager;

    public function __construct(AccessDecisionManagerInterface $decisionManager)
    {
        $this->decisionManager = $decisionManager;
    }

    protected function supports($attribute, $subject)
    {
        // Est-ce que l'action demandée existe
        if (!in_array($attribute, array(self::ADD, self::GET, self::EDIT, self::REMOVE))) {
            return false;
        }

        // On ne vote que pour des objets de type User
        if (!$subject instanceof User) {
            return false;
        }

        return true;
    }

    protected function voteOnAttribute($attribute, $subject, TokenInterface $token)
    {
        $user = $token->getUser();

        if (!$user instanceof User) {
            // L'utilisateur doit être loggué
            return false;
        }

        // Les admins peuvent tout faire !
        if ($this->decisionManager->decide($token, array('ROLE_SUPER_ADMIN', 'ROLE_ADMIN'))) {
            return true;
        }

        switch ($attribute) {
            case self::ADD:
                return $this->canAdd($subject, $user);
            case self::GET:
                return $this->canGet($subject, $user);
            case self::EDIT:
                return $this->canEdit($subject, $user);
            case self::REMOVE:
                return $this->canRemove($subject, $user);
        }

        throw new \LogicException('This code should not be reached!');
    }

    private function canAdd(User $subject, User $user)
    {
        if ($this->decisionManager->decide($token, array('ROLE_ADHERENT'))) {
            return false;
        }
    }

    private function canGet(User $subject, User $user)
    {
    }

    private function canEdit(User $subject, User $user)
    {
    }

    private function canRemove(User $subject, User $user)
    {
    }
}
