<?php

namespace App\Form\Type;

use App\Entity\User;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityRepository;
use FOS\UserBundle\Form\Type\RegistrationFormType as FOSRegistrationFormType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormError;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class RegistrationFormType extends AbstractRegistrationFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->remove('username')
            ->add('email', TextType::class, array('label' => 'form_label_email'))
            ->add('firstname', TextType::class, array('label' => 'form_label_first_name'))
            ->add('lastname', TextType::class, array('label' => 'form_label_family_name'))
            ->add('plainPassword', RepeatedType::class, array(
                'type' => 'password',
                'options' => array('translation_domain' => 'FOSUserBundle'),
                'first_options' => array('label' => 'form.password'),
                'second_options' => array('label' => 'form.password_confirmation'),
                'invalid_message' => 'fos_user.password.mismatch',
                'error_bubbling' => true
            ))
            ->addEventListener(FormEvents::POST_SUBMIT, function (FormEvent $event) use ($builder) {
                $repo = $this->em->getRepository(User::class);
                $emailExist = $repo->findBy(array('email' => $event->getForm()->get('email')->getData()));
                if (count($emailExist) > 0) {
                    $event->getForm()->get('email')->addError(new FormError('form_label_email_used'));
                }
            })
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'cascade_validation' => true,
            'type' => null
        ));
    }

    public function getParent()
    {
        return FOSRegistrationFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'app_user_registration';
    }
}
