<?php

namespace App\Entity;

use App\Entity\EntityTrait\HasCompteEntity;
use App\Entity\EntityTrait\NameSlugContentEntityTrait;
use App\Entity\Groupe;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="siege")
 */
class Siege
{
    use NameSlugContentEntityTrait,
        HasCompteEntity;

    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var ArrayCollection|Groupe[]
     * @ORM\OneToMany(targetEntity="Groupe", mappedBy="siege", cascade={"persist"})
     */
    private $groupes;

    public function __construct()
    {
        $this->groupes = new ArrayCollection();
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return Groupe[]|ArrayCollection
     */
    public function getGroupes()
    {
        return $this->groupes;
    }

    /**
     * @param Groupe $groupe
     * @return $this
     */
    public function addGroupe(Groupe $groupe)
    {
        if (!$this->groupes->contains($groupe)) {
            $this->groupes[] = $groupe;
            $groupe->setSiege($this);
        }
        return $this;
    }

    /**
     * @param Groupe $groupe
     * @return $this
     */
    public function removeGroupe(Groupe $groupe)
    {
        if ($this->groupes->contains($groupe)) {
            $this->groupes->removeElement($groupe);
            $groupe->setSiege(null);
        }
        return $this;
    }
}
