<?php
/**
 * AMAP class
 *
 * @package Default
 * @author
 **/
namespace App\Entity;

use App\Entity\EntityTrait\ContactEmailTelTrait;
use App\Entity\EntityTrait\EnablableEntityTrait;
use App\Entity\EntityTrait\GeolocEntityTrait;
use App\Entity\EntityTrait\NameSlugContentEntityTrait;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Gedmo\Timestampable\Traits\TimestampableEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="groupeprestaire")
 */
class Groupeprestataire
{
    use NameSlugContentEntityTrait,
        TimestampableEntity,
        GeolocEntityTrait,
        EnablableEntityTrait;

    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\Column(name="id", type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var ArrayCollection|Prestataire[]
     *
     * @ORM\ManyToMany(targetEntity="Prestataire", inversedBy="groupeprestataires", cascade={"persist"}, fetch="EXTRA_LAZY")
     */
    protected $prestataires;

    /**
     * @var null|string (champ libre)
     *
     * @ORM\Column(name="horaires", type="string", length=255, nullable=true)
     */
    private $horaires;

    public function __construct()
    {
        $this->prestataires = new ArrayCollection();
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
    * Get horaires
    * @return string Horaires
    */
    public function getHoraires(): ?string
    {
        return $this->horaires;
    }

    /**
    * Set horaires
    * @return $this
    */
    public function setHoraires($horaires): self
    {
        $this->horaires = $horaires;
        return $this;
    }

    /**
     * @return Prestataire[]|ArrayCollection
     */
    public function getPrestataires()
    {
        return $this->prestataires;
    }

    /**
     * @param Prestataire $prestataire
     * @return $this
     */
    public function addPrestataire(Prestataire $prestataire): self
    {
        if (!$this->prestataires->contains($prestataire)) {
            $this->prestataires[] = $prestataire;
            $prestataire->addGroupeprestataire($this);
        }
        return $this;
    }

    /**
     * @param Prestataire $prestataire
     * @return $this
     */
    public function removePrestataire(Prestataire $prestataire): self
    {
        if ($this->prestataires->contains($prestataire)) {
            $this->prestataires->removeElement($prestataire);
            $prestataire->removeGroupeprestataire($this);
        }
        return $this;
    }

    public function getPrestatairesCount()
    {
        return $this->getPrestataires()->count();
    }
}
