<?php

namespace App\Admin;

use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use App\Application\Sonata\UserBundle\Admin\UserAdmin as SonataUserAdmin;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;

class UserAdmin extends SonataUserAdmin
{
    protected $baseRouteName = 'user';
    protected $baseRoutePattern = 'user';

    protected $datagridValues = [
        // reverse order (default = 'ASC')
        '_sort_order' => 'DESC',
        // name of the ordered field (default = the model's id field, if any)
        '_sort_by' => 'updatedAt',
    ];

    public function configure()
    {
        parent::configure();
        // $this->classnameLabel = "Utilisateurs";
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper): void
    {
        parent::configureFormFields($formMapper);

        $user = $this->getSubject();
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper): void
    {
        parent::configureListFields($listMapper);
        unset($this->listModes['mosaic']);
        // $listMapper
            // ->addIdentifier('username', null, array('label' => 'Username'))
            // ->addIdentifier('email', null, array('label' => 'Email'));
    }

    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->remove('delete');
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        $datagridMapper
            ->add('enabled')
            // ->add('email', null, [
            //     'show_filter' => true
            // ])
        ;
    }

    /**
    * {@inheritdoc}
    */
    // protected function configureRoutes(RouteCollection $collection)
    // {
    //     // $collection->remove('create');
    //     // if (!$this->isGranted('ROLE_SUPER_ADMIN')) {
    //     //     $collection->clearExcept([]);
    //     // }
    //     if ($this->isChild()) {
    //         return;
    //     }

    //     // This is the route configuration as a parent
    //     // $collection->clear();
    // }
}
