<?php

namespace App\Admin;

use App\Entity\Comptoir;
use App\Entity\Prestataire;
use App\Entity\Siege;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class RubriqueAdmin extends AbstractAdmin
{
    protected $datagridValues = [
        '_sort_order' => 'ASC',
        '_sort_by' => 'name',
    ];

    /**
    * {@inheritdoc}
    */
    protected function configureShowFields(ShowMapper $showMapper)
    {
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper)
    {
        $groupe = $this->getSubject();
        $formMapper
            ->with("Creation d'une rubrique")
                ->add('name', TextType::class, array(
                    'label' => 'Nom :',
                    'required' => true
                ))
                ->add('prestataires', CollectionType::class, array(
                    'label' => 'Prestataires',
                    'entry_type' => EntityType::class,
                    'entry_options' => array(
                        'class' => Prestataire::class,
                        'choices' =>  $this->getConfigurationPool()->getContainer()->get('doctrine')->getRepository(Prestataire::class)->findBy(array('enabled' => true)),
                        // 'choice_label' => 'name',
                        'placeholder' => 'Choisir un prestataire',
                        'required' => false,
                        'label' => false),
                    'by_reference' => false,
                    'allow_add' => true,
                    'allow_delete' => true
                ))
                ->add('enabled', CheckboxType::class, array(
                    'label' => 'Activé ?',
                    'required' => false,
                    'label_attr' => array('class' => 'checkbox-inline')
                ))
            ->end()
        ;
    }

    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->remove('delete');
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('name', null, array('label' => 'Nom du groupe'))
            ->add(
                'getPrestatairesCount',
                null,
                [
                    'label' => 'Nb prestataires',
                    'sortable' => true,
                    'sort_field_mapping' => ['fieldName' => 'id'],
                    'sort_parent_association_mappings' => [],
                ]
            )
            ->addIdentifier('enabled', null, array('label' => 'Activé', 'datatype' => 'App.Groupeprestataire', 'template' => '@SonataAdmin/Boolean/editable_boolean.html.twig'))
        ;
    }
}
