<?php

namespace App\Admin;

use App\Admin\UserAdmin;
use App\Entity\Geoloc;
use App\Entity\Prestataire;
use App\Entity\Usergroup;
use FOS\UserBundle\Model\UserManagerInterface;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Sonata\MediaBundle\Form\Type\MediaType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;

class PrestataireAdmin extends UserAdmin
{
    protected $baseRouteName = 'prestataire';
    protected $baseRoutePattern = 'prestataire';
    protected $datagridValues = [
        '_page' => 1,
        '_per_page' => 32,
    ];


    public function configure()
    {
        parent::configure();
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper): void
    {
        // Initialize prestataire
        $user = $this->getSubject();
        $groupe = $this->getConfigurationPool()->getContainer()->get('doctrine')->getRepository(Usergroup::class)->findOneByName('Prestataire');
        $user->setEnabled(true);
        $user->addGroup($groupe);
        $user->addRole('ROLE_PRESTATAIRE');
        $presta = new Prestataire();
        $presta->setGeoloc(new Geoloc());
        $user->setPrestataire($presta);

        // get the current Image instance
        $imageHelp = null;
        if (!empty($user->getPrestataire()) && !empty($user->getPrestataire()->getMedia())) {
            $image = $user->getPrestataire()->getMedia();
            if ($image && ($webPath = $image->getWebPath())) {
                // get the container so the full path to the image can be set
                $container = $this->getConfigurationPool()->getContainer();
                $fullPath = $container->get('request_stack')->getCurrentRequest()->getBasePath().'/'.$webPath;
                // add a 'help' option containing the preview's img tag
                $imageHelp = '<img src="'.$fullPath.'" class="admin-preview" />';
            }
        }

        $formMapper
            ->tab('Prestataire')
                ->with('General', ['class' => 'col-md-7'])
                    ->add('prestataire.raison', TextType::class, array(
                        'label' => 'Raison :',
                        'required' => true
                    ))
                    ->add('prestataire.statut', TextType::class, array(
                        'label' => 'Statut :',
                        'required' => false
                    ))
                    ->add('prestataire.siret', TextType::class, array(
                        'label' => 'SIRET :',
                        'required' => true
                    ))
                    ->add('prestataire.iban', TextType::class, array(
                        'label' => 'IBAN :',
                        'required' => true
                    ))
                ->end()
                ->with('Responsable', ['class' => 'col-md-5'])
                    ->add('prestataire.metier', TextType::class, array(
                        'label' => 'Métier :',
                        'required' => true
                    ))
                    ->add('prestataire.responsable', TextType::class, array(
                        'label' => 'Responsable :',
                        'required' => false
                    ))
                ->end()
                ->with('Addresse', ['class' => 'col-md-7'])
                    ->add('prestataire.geoloc.adresse', TextType::class, array(
                        'label' => 'Addresse :',
                        'required' => false
                    ))
                    ->add('prestataire.geoloc.cpostal', TextType::class, array(
                        'label' => 'Code postal :',
                        'required' => false
                    ))
                    ->add('prestataire.geoloc.ville', TextType::class, array(
                        'label' => 'Ville :',
                        'required' => false
                    ))
                    ->add('prestataire.geoloc.lat', TextType::class, array(
                        'label' => 'Latitude :',
                        'required' => false
                    ))
                    ->add('prestataire.geoloc.lon', TextType::class, array(
                        'label' => 'Longitude :',
                        'required' => false
                    ))
                ->end()
                ->with('Image', ['class' => 'col-md-5'])
                    ->add('prestataire.media', MediaType::class, array(
                        'provider' => 'sonata.media.provider.image',
                        'context' => 'prestataire',
                        'help' => $imageHelp
                    ))
                ->end()
            ->end()
        ;
        parent::configureFormFields($formMapper);
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        parent::configureDatagridFilters($datagridMapper);
        $datagridMapper
            ->add('prestataire.raison')
            ->add('prestataire.statut')
        ;
    }

    /**
     * @param UserManagerInterface $userManager
     */
    public function setUserManager(UserManagerInterface $userManager): void
    {
        $this->userManager = $userManager;
    }

    /**
     * @return UserManagerInterface
     */
    public function getUserManager()
    {
        return $this->userManager;
    }

    protected function configureListFields(ListMapper $listMapper): void
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('username')
            ->addIdentifier('email')
            ->addIdentifier('prestataire.raison')
            ->addIdentifier('enabled', null, array('label' => 'Activé', 'datatype' => 'App.User', 'template' => '@SonataAdmin/Boolean/editable_boolean.html.twig'))
            ->addIdentifier('createdAt')
        ;

        if ($this->isGranted('ROLE_ALLOWED_TO_SWITCH')) {
            $listMapper
                ->addIdentifier('impersonating', 'string', ['template' => '@SonataUser/Admin/Field/impersonating.html.twig'])
            ;
        }
    }

    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->remove('delete');
    }

    /**
    * {@inheritdoc}
    */
    public function createQuery($context = 'list')
    {
        $query = parent::createQuery($context);
        $query->andWhere($query->getRootAliases()[0] . '.prestataire IS NOT NULL');
        return $query;
    }
}
