<?php

namespace App\Admin;

use App\Entity\Comptoir;
use App\Entity\Siege;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class GroupeAdmin extends AbstractAdmin
{
    protected $datagridValues = [
        '_sort_order' => 'ASC',
        '_sort_by' => 'name',
    ];

    /**
    * {@inheritdoc}
    */
    protected function configureShowFields(ShowMapper $showMapper)
    {
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper)
    {
        $groupe = $this->getSubject();
        $formMapper
            ->with("Creation d'un groupe")
                ->add('siege', HiddenType::class, array(
                    'data' => 1,
                    'data_class' => null,
                    'entity_class' => Siege::class,
                    'em' => $this->getConfigurationPool()->getContainer()->get('doctrine')->getManager()
                ))
                ->add('name', TextType::class, array(
                    'label' => 'Nom du groupe :',
                    'required' => true
                ))
                ->add('comptoirs', CollectionType::class, array(
                    'label' => 'Comptoirs',
                    'entry_type' => EntityType::class,
                    'entry_options' => array(
                        'class' => Comptoir::class,
                        'choices' =>  $this->getConfigurationPool()->getContainer()->get('doctrine')->getRepository(Comptoir::class)->findAll(),
                        'choice_label' => 'slug',
                        'placeholder' => 'Comptoir',
                        'required' => false,
                        'label' => false),
                    'by_reference' => false,
                    'allow_add' => true,
                    'allow_delete' => true
                ))
                ->add('enabled', CheckboxType::class, array(
                    'label' => 'Activé ?',
                    'required' => false,
                    'label_attr' => array('class' => 'checkbox-inline')
                ))
            ->end()
        ;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        $datagridMapper
            ->add('enabled')
        ;
    }

    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->remove('delete');
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('name', null, array('label' => 'Nom du groupe'))
            ->add(
                'getPrestatairesCount',
                null,
                [
                    'label' => 'Nb prestataires',
                    'sortable' => true,
                    'sort_field_mapping' => ['fieldName' => 'id'],
                    'sort_parent_association_mappings' => [],
                ]
            )
            ->add(
                'getComptoirsCount',
                null,
                [
                    'label' => 'Nb comptoirs',
                    'sortable' => true,
                    'sort_field_mapping' => ['fieldName' => 'id'],
                    'sort_parent_association_mappings' => [],
                ]
            )
            ->addIdentifier('enabled', null, array('label' => 'Activé', 'datatype' => 'App.Groupeprestataire', 'template' => '@SonataAdmin/Boolean/editable_boolean.html.twig'))
        ;
    }
}
