<?php

namespace App\Admin;

use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Show\ShowMapper;
use Sonata\MediaBundle\Form\Type\MediaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class DocumentAdmin extends AbstractAdmin
{

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper)
    {
        $document = $this->getSubject();
        $formMapper
            ->add('name', TextType::class, array(
                'label' => 'Titre :'
            ))
            ->add('text', CKEditorType::class, array(
                'label' => 'Texte',
                'required' => false,
            ))
            ->add('media', MediaType::class, array('provider' => 'sonata.media.provider.image', 'context' => 'document'))
        ;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('name', null, array('label' => 'Titre'))
            ->addIdentifier('text', 'html', array('label' => 'Text'))
            ->addIdentifier('media', null, array('label' => 'Fichier'))
        ;
    }
}
