<?php

namespace App\Admin;

use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;

class CotisationAdmin extends AbstractAdmin
{
    protected $baseRouteName = 'cotisation';
    protected $baseRoutePattern = 'cotisation';

    /**
    * {@inheritdoc}
    */
    protected function configureShowFields(ShowMapper $showMapper)
    {
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper)
    {
        $cotisation = $this->getSubject();
        $formMapper
            ->with('Cotisation', ['class' => 'col-md-8'])
                // ->add('user', null, array('label' => 'Utilisateur'), array('admin_code' => 'admin.adherent.gerer'))
                ->add('type', null, array('label' => 'Type'))
                ->add('annee', null, array('label' => 'Année'))
                ->add('montant', null, array('label' => 'Montant'))
                ->add('moyen', null, array('label' => 'Moyen'))
                ->add('recu', null, array('label' => 'Reçu'))
            ->end()
            ->with('Date', ['class' => 'col-md-4'])
                ->add('debut', null, array(
                    'label' => 'Date de début',
                    'data' => new \DateTime(),
                    'widget' => 'single_text',
                    'html5' => false,
                    'attr' => ['class' => 'js-datepicker'],
                    )
                )
                ->add('fin', null, array(
                    'label' => 'Date de fin',
                    'data' => new \DateTime('+ 1 year'),
                    'widget' => 'single_text',
                    'html5' => false,
                    'attr' => ['class' => 'js-datepicker'],
                    )
                )
            ->end()
        ;
    }

    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->remove('edit');
        $collection->remove('delete');
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            // ->addIdentifier('user')
            ->addIdentifier('type')
            ->addIdentifier('annee')
            ->addIdentifier('debut')
            ->addIdentifier('fin')
            ->addIdentifier('montant')
            ->addIdentifier('moyen')
            ->addIdentifier('createdAt')
        ;
    }
}
