<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Util;

use App\Entity\User;
use App\Entity\GlobalParameter;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Contracts\HttpClient\HttpClientInterface;

class WordpressUtil
{
    protected $em;
    protected $client;
    protected $apiKey = null;
    protected $isUsed = null;
    protected $url = null;

    public function __construct(EntityManagerInterface $em, HttpClientInterface $client)
    {
        $this->em = $em;
        $this->client = $client;
    }

    public function getApiKey(): string
    {
        if (null !== $this->apiKey) {
            return $this->apiKey;
        }

        $users = $this->em->getRepository(User::class)->findByRole('ROLE_API');

        return $this->apiKey = $users[0]->getApiKey() ?? '';
    }

    public function getUrl(): string
    {
        if (null !== $this->url) {
            return $this->url;
        }

        return $this->url = $this->em->getRepository(GlobalParameter::class)
                                     ->val(GlobalParameter::WORDPRESS_URL);
    }

    /**
     * Determine whether Wordpress is used or not.
     *
     * @return bool
     */
    public function isUsed(): bool
    {
        if (null !== $this->isUsed) {
            return $this->isUsed;
        }

        return $this->isUsed = (
            'true' === $this->em->getRepository(GlobalParameter::class)
                                ->val(GlobalParameter::USE_WORDPRESS)
            ? true
            : false
        );
    }

    /**
     * Determine whether synchronization with Wordpress is available or not.
     *
     * @return bool
     */
    public function canSync(): bool
    {
        return $this->isUsed() && $this->getUrl();
    }

    /**
     * Run the synchronization with Wordpress, through an API call.
     * Actually, only 'Prestataires' can be sync.
     *
     * @param array|int|null $id  If null, ask for a full sync.
     *
     * @return bool  Return false if the sync isn't run. Else true.
     */
    public function runSync($id = null): bool
    {
        if (! $this->canSync()) {
            return false;
        }

        $endpoint = sprintf("%s/%s/%s",
            $this->getUrl(),
            "wp-json/wosmpl/v1/sync_partners",
            null === $id ? '' : ('?ids=' . \implode(',', (array) $id))
        );

        $this->client->request('GET', $endpoint, [
            'headers' => [
                'API-AUTH-TOKEN' => $this->getApiKey(),
            ],
        ]);

        return true;
    }
}
