<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Twig;

use App\Entity\TypePrestataire;
use App\Entity\User;
use Doctrine\ORM\EntityManagerInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;
use Twig\TwigFunction;
use Twig\TwigTest;

class StatsExtension extends AbstractExtension
{
    protected $em;

    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * {@inheritdoc}
     */
    public function getFunctions()
    {
        return array(
            new \Twig_SimpleFunction('showMlcStats', array($this, 'showMlcStats'))
        );
    }

    public function showMlcStats($stats)
    {
        $class = '';
        switch ($stats) {
            case 'user':
                $class = 'App\Entity\User';
                break;
            case 'prestataire':
                $class = null;
                $typepresta = $this->em->getRepository(TypePrestataire::class)->findOneBySlug('prestataire');
                $query = $this->em->createQuery(
                    'SELECT count(distinct p.id)
                    FROM App\\Entity\\Prestataire p
                    WHERE p.enabled = true AND p.typeprestataire = :typepresta'
                )->setParameter('typepresta', $typepresta);

                $val = $query->getSingleScalarResult();
                break;
            case 'partenaire':
                $class = null;
                $typepresta = $this->em->getRepository(TypePrestataire::class)->findOneBySlug('partenaire');
                $query = $this->em->createQuery(
                    'SELECT count(distinct p.id)
                    FROM App\\Entity\\Prestataire p
                    WHERE p.enabled = true AND p.typeprestataire = :typepresta'
                )->setParameter('typepresta', $typepresta);

                $val = $query->getSingleScalarResult();
                break;
            case 'adherent':
                $class = 'App\Entity\Adherent';
                break;
            case 'comptoir':
                $class = 'App\Entity\Comptoir';
                break;
            case 'groupe':
                $class = 'App\Entity\Groupe';
                break;
        }
        if (!empty($class)) {
            $query2 = $this->em->createQuery(
                'SELECT count(distinct u.id)
                FROM '.$class.' u
                WHERE u.enabled = true'
            );

            $val = $query2->getSingleScalarResult();
        }

        return $val;
    }
}
