<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Twig;

use App\Entity\GlobalParameter;
use Doctrine\ORM\EntityManager;
use Twig\Extension\AbstractExtension;
use Twig\Extension\GlobalsInterface;

class MlcGlobalsExtension extends AbstractExtension implements GlobalsInterface
{
    protected $em;

    public function __construct(EntityManager $em)
    {
        $this->em = $em;
    }

    public function getGlobals()
    {
        $arrayGlobals = $this->em->getRepository(GlobalParameter::class)->findAllByName();
        
        // @TODO : Better default param if not exist
        if (!isset($arrayGlobals['KOH_MAP_CENTER'])) {
            $arrayGlobals['KOH_MAP_CENTER'] = '[46.898,3.230]';
        }
        if (!isset($arrayGlobals['KOH_MAP_ZOOM'])) {
            $arrayGlobals['KOH_MAP_ZOOM'] = '6';
        }

        return $arrayGlobals;
    }
}
