<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Form\Type;

use App\Entity\Adherent;
use App\Entity\TransactionAdherentAdherent;
use App\Enum\MoyenEnum;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TransactionAdherentAdherentFormType extends TransactionFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('expediteur', HiddenType::class, array(
                'data' => $this->security->getUser()->getAdherent()->getId(),
                'data_class' => null,
                'entity_class' => Adherent::class,
                'em' => $this->em
            ))
            ->add('destinataire', EntityType::class, array(
                'class' => Adherent::class,
                'choices' =>  $this->em->getRepository(Adherent::class)->findbyExclude($this->security->getUser()->getAdherent()),
                'placeholder' => 'Adherent',
                'required' => true,
                'label' => 'Adherent :',
            ))
            ->add('destinataireType', HiddenType::class, array(
                'data' => 'adherent',
                'mapped' => false
            ))
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'class' => TransactionAdherentAdherent::class,
        ));
    }

    public function getParent()
    {
        return TransactionFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formTransactionAdherentAdherent';
    }
}
