<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Form;

use App\Form\EntityToIdTransformer;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class HiddenEntityExtension extends AbstractTypeExtension
{
    public static function getExtendedTypes()
    {
        return array(HiddenType::class);
    }

    /**
     * Add the entity_class option
     *
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefined(array('em'));
        $resolver->setDefined(array('entity_class'));
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        if (isset($options['em'])&&isset($options['entity_class'])) {
            $builder->addModelTransformer(new EntityToIdTransformer(
                $options['em'],
                $options['entity_class']
            ));
        }
    }
}
