<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Entity;

use App\Entity\Siege;
use Doctrine\ORM\Mapping as ORM;

/**
 * Achat de monnaie en CB par un Adhérent ou Prestataire
 *
 * @ORM\Entity
 */
class AchatMonnaie extends Flux
{
    /**
     * @ORM\ManyToOne(targetEntity="Siege")
     * @ORM\JoinColumn(name="siege_id", referencedColumnName="id", nullable=true)
     */
    protected $expediteur;

    public function operate($em)
    {
        // Increment Ecompte of Siege
        $this->getExpediteur()->addEcompte($this->getMontant());
        $this->getDestinataire()->addEcompte($this->getMontant());

        return [$this->getExpediteur(), $this->getDestinataire()];
    }

    public function getUsersToNotify()
    {
        return ['siege'];
    }

    /**
     * @return string
     */
    public function getParenttype(): string
    {
        return self::TYPE_ACHAT;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'achat_monnaie';
    }

}
