<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Controller;

use App\Entity\User;
use App\Entity\CotisationAdherent;
use App\Entity\CotisationPrestataire;
use App\Entity\Payment;
use App\Enum\MoyenEnum;
use App\Form\Type\CotiserFormType;
use App\Form\Type\UserInfosFormType;
use Doctrine\ORM\EntityManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Translation\TranslatorInterface;
use Symfony\Component\Security\Core\Security;

class UserController extends AbstractController
{
    private $em;
    private $translator;
    private $security;

    public function __construct(EntityManagerInterface $em, TranslatorInterface $translator, Security $security)
    {
        $this->em = $em;
        $this->translator = $translator;
        $this->security = $security;
    }

    /**
     * @Route("/cotiser", name="cotiser")
     * @IsGranted("ROLE_USER")
     */
    public function cotiserAction(Request $request)
    {
        $options = [];
        $payment_type = '';
        if ($this->security->getUser()->isGranted('ROLE_ADHERENT')) {
            $options['data_class'] = CotisationAdherent::class;
            $payment_type = Payment::TYPE_COTISATION_ADHERENT;
        } elseif ($this->security->getUser()->isGranted('ROLE_PRESTATAIRE')) {
            $options['data_class'] = CotisationPrestataire::class;
            $payment_type = Payment::TYPE_COTISATION_PRESTA;
        }

        $form = $this->createForm(CotiserFormType::class, null, $options);
        $form->handleRequest($request);

        if ($form->isSubmitted()) {
            $cotisation = $form->getData();
            if ($form->isValid()) {
                if ($cotisation->getMoyen() == MoyenEnum::MOYEN_MLC) {
                    $cotisation->setRecu(true);
                    $this->em->persist($cotisation);
                    $this->em->flush();
                    $this->addFlash(
                        'success',
                        // "Cotisation pour l'année {$cotisation->getCotisationInfos()->getAnnee()} bien reçue. Merci !"
                        $this->translator->trans("Cotisation bien reçue. Merci !")
                    );
                    return $this->redirectToRoute('index');
                } else {
                    // Redirect to payment page
                    return $this->forward('App\Controller\FluxController::preparePaymentAction', [
                        'form'  => $form,
                        'type'  => $payment_type
                    ]);
                }
            } else {
                $this->addFlash(
                    'error',
                    $this->translator->trans('Problème avec la cotisation !') . ' ' . $form->getErrors()
                );
            }
        }

        return $this->render('cotiser.html.twig', array(
            'form' => $form->createView()
        ));
    }

    /**
     * @Route("/userinfos", name="user_infos")
     * @IsGranted("ROLE_USER")
     */
    public function userInfosAction(Request $request)
    {
        $form = $this->createForm(UserInfosFormType::class, $this->getUser());
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->em->persist($form->getData());
            $this->em->flush();
            $this->addFlash(
                'success',
                $this->translator->trans("Infos de l'utilisateur modifiée !")
            );
            $referer = $request->headers->get('referer');
            if ($referer && !$request->isXmlHttpRequest()) {
                return $this->redirect($referer);
            } elseif (!$request->isXmlHttpRequest()) {
                return new Response('', Response::HTTP_BAD_REQUEST);
            }
        }
        return $this->redirectToRoute('index');
        // return $this->render('presta/infos.html.twig', array(
        //     'form' => $form->createView()
        // ));
    }
}
