<?php

namespace App\Form\Type;

use App\Entity\Comptoir;
use App\Entity\Groupe;
use App\Entity\TransfertComptoirGroupe;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TransfertComptoirGroupeFormType extends TransfertFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('expediteur', EntityType::class, array(
                'choices' => $this->em->getRepository(Comptoir::class)->findBy(array('enabled' => true, 'groupe' => $this->session->get('_groupegere')), array('name'=> 'ASC')),
                'class' => Comptoir::class,
                'placeholder' => 'Comptoir',
                'required' => true,
                'label' => 'Comptoir :',
            ))
            ->add('destinataire', HiddenType::class, array(
                'entity_class' => Groupe::class,
                'data' =>  $this->session->get('_groupegere')->getId(),
                'data_class' => null,
                'em' => $this->em
            ))
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'class' => TransfertComptoirGroupe::class,
        ));
    }

    public function getParent()
    {
        return TransfertFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formTransfertComptoirGroupe';
    }
}
