<?php

namespace App\Form\Type;

use App\Entity\CotisationInfos;
use App\Entity\User;
use Doctrine\DBAL\Types\FloatType;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class CotisationInfosFormType extends FluxFormType
{
    protected $security;

    public function __construct(Security $security)
    {
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $now = new \DateTime();
        $builder
            ->add('annee', TextType::class, array(
                'label' => 'Année',
                'data' => $now->format('Y')
            ))
            ->add('debut', DateType::class, array(
                'label' => 'Date de début',
                'data' => new \DateTime(),
                'widget' => 'single_text',
                'html5' => false,
                'attr' => ['class' => 'js-datepicker'],
            ))
            ->add('fin', DateType::class, array(
                'label' => 'Date de fin',
                'data' => new \DateTime('+ 1 year'),
                'widget' => 'single_text',
                'html5' => false,
                'attr' => ['class' => 'js-datepicker'],
            ));
        if ($this->security->getUser() != null && $this->security->getUser()->isGranted('ROLE_TRESORIER')) {
            $builder
                    ->add('recu', CheckboxType::class, array('label' => 'Reçu'));
        }
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => CotisationInfos::class,
            'cascade_validation' => true
        ));
    }


    public function getBlockPrefix()
    {
        return 'formCotisationInfos';
    }
}
