<?php

namespace App\Form\Type;

use App\Entity\Siege;
use App\Enum\MoyenEnum;
use App\Form\Type\FluxFormType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;

class AchatMonnaieFormType extends FluxFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('moyen', HiddenType::class, array(
                'data' => MoyenEnum::MOYEN_CB
            ))
            ->add('expediteur', HiddenType::class, array(
                'data' => 1,
                'data_class' => null,
                'entity_class' => Siege::class,
                'em' => $this->em
            ))
        ;
    }

    public function getParent()
    {
        return FluxFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formAchatMonnaie';
    }
}
