<?php

namespace App\Entity;

use App\Entity\Adherent;
use Doctrine\ORM\Mapping as ORM;

/**
 * TRANSACTION
 *  - Achat de monnaie en CB par un Adhérent
 *
 * @ORM\Entity
 */
class AchatMonnaieAdherent extends AchatMonnaie
{
  /**
   * @ORM\ManyToOne(targetEntity="Adherent")
   * @ORM\JoinColumn(name="adherent_dest_id", referencedColumnName="id", nullable=true)
   */
  protected $destinataire;

  /**
   * @return string
   */
  public function getType(): string
  {
      return 'achat_monnaie_adherent';
  }
}
