<?php

namespace App\Events;

use App\Entity\Flux;
use Symfony\Component\EventDispatcher\Event;

class FluxEvent extends Event
{
    protected $flux;

    /**
     * @param FormInterface $form The associated form
     * @param mixed         $data The data
     */
    public function __construct(Flux $flux)
    {
        $this->flux = $flux;
    }

    /**
    * Get flux
    * @return
    */
    public function getFlux()
    {
        return $this->flux;
    }
    
    /**
    * Set flux
    * @return $this
    */
    public function setFlux($flux)
    {
        $this->flux = $flux;
        return $this;
    }
}
