<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RETRAIT
 *  - PRESTATAIRES     =>    COMPTOIR      (Retrait d'un prestataire)
 *
 * @ORM\Entity()
 */
class RetraitComptoirPrestataire extends Retrait
{
    /**
     * @ORM\OneToOne(targetEntity="Prestataire")
     * @ORM\JoinColumn(name="prestataire_id", referencedColumnName="id")
     */
    protected $destinataire;

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'retrait_prestataire';
    }

    public function getUsersToNotify()
    {
        return array_merge($this->getExpediteur()->getGestionnaires()->toArray(), $this->getDestinataire()->getUsers()->toArray());
    }
}
