<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Retrait => (Retrait de monnaie papier en échange de monnaie numérique)
 *
 * Types de retraits :
 *
 *   - ADHERENTS        =>    COMPTOIR         (Retrait d'un adherent)
 *   - PRESTATAIRES     =>    COMPTOIR      (Retrait d'un prestataire)
 *
 * @ORM\Entity
 */
abstract class Retrait extends Flux
{
    /**
     * @ORM\OneToOne(targetEntity="Comptoir")
     * @ORM\JoinColumn(name="comptoir_id", referencedColumnName="id")
     */
    protected $expediteur;

    /**
     * @return string
     */
    public function getParenttype(): string
    {
        return self::TYPE_RETRAIT;
    }

    public function operate($em)
    {
        $compteExp = $this->getExpediteur()->getCompte() - $this->getMontant();
        if ($compteExp < 0) {
            throw new \Exception("[FLUX] Retrait impossible ! Montant supérieur au solde du comptoir !");
        } else {
            $this->getExpediteur()->removeCompte($this->getMontant());
            $this->getExpediteur()->getGroupe()->getSiege()->addCompteNantie($this->getMontant());
            $this->getDestinataire()->removeEcompte($this->getMontant());

            return [$this->getExpediteur(), $this->getDestinataire(), $this->getExpediteur()->getGroupe()->getSiege()];
        }
        return [];
    }
}
