<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;

/**
 * @ORM\Entity(repositoryClass="App\Repository\GlobalParameterRepository")
 * @UniqueEntity(
 *     fields={"name"},
 *     errorPath="name",
 *     message="Ce nom de paramètre est déjà utilisé !"
 * )
 */
class GlobalParameter
{
    // Default global parameters for MLC
    const USE_WORDPRESS             = 'USE_WORDPRESS';
    const MLC_NAME                  = 'MLC_NAME';
    const MLC_NAME_SMALL            = 'MLC_NAME_SMALL';
    const MLC_NOTIF_EMAIL           = 'MLC_NOTIF_EMAIL';
    const MLC_CONTACT_EMAIL         = 'MLC_CONTACT_EMAIL';
    const COTISATION_ADHERENT       = 'COTISATION_ADHERENT';
    const COTISATION_PRESTATAIRE    = 'COTISATION_PRESTATAIRE';
    const RECONVERSION_PRESTATAIRE  = 'RECONVERSION_PRESTATAIRE';
    const MAP_CENTER                = 'MAP_CENTER';
    const MAP_ZOOM                  = 'MAP_ZOOM';

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $name;

    /**
     * @ORM\Column(type="text")
     */
    private $value;

    /**
     * @ORM\Column(type="boolean")
     */
    private $mandatory;

    public function __toString()
    {
        return $this->getName(). ' => '.$this->getValue();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getValue(): ?string
    {
        return $this->value;
    }

    public function setValue(string $value): self
    {
        $this->value = $value;

        return $this;
    }

    /**
    * Get mandatory
    * @return
    */
    public function getMandatory()
    {
        return $this->mandatory;
    }
    
    /**
    * Set mandatory
    * @return $this
    */
    public function setMandatory($mandatory)
    {
        $this->mandatory = $mandatory;
        return $this;
    }
}
