<?php

namespace App\Entity\EntityTrait;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Serializer\Annotation\Groups;

trait HasEcompteEntity
{
    /**
     * Compte de MLC numérique
     * @var int
     *
     * @ORM\Column(name="ecompte", type="decimal", precision=12, scale=2)
     * @Groups({"read"})
     */
    private $ecompte = 0;

    /**
     * @return int
     */
    public function getEcompte(): float
    {
        return $this->ecompte;
    }

    /**
     * @param int $ecompte
     * @return $this
     */
    public function setEcompte(float $ecompte)
    {
        $this->ecompte = $ecompte;
        return $this;
    }

    /**
     * Incremente le ecompte
     * @param int $ecompte
     * @return $this
     */
    public function addEcompte(float $ecompte)
    {
        $this->ecompte += $ecompte;
        return $this;
    }

    /**
     * Décremente le ecompte
     * @param int $ecompte
     * @return $this
     */
    public function removeEcompte(float $ecompte)
    {
        $this->ecompte -= $ecompte;
        return $this;
    }
}
