<?php

namespace App\Entity;

use App\Entity\EntityTrait\EnablableEntityTrait;
use App\Entity\EntityTrait\NameSlugContentEntityTrait;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Timestampable\Traits\TimestampableEntity;
use Symfony\Component\Validator\Constraints as Assert;
use ApiPlatform\Core\Annotation\ApiResource;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * ApiResource(
 *     attributes={"security"="is_granted('ROLE_ADMIN_DOCUMENT_GERER_VIEW')"},
 *     collectionOperations={
 *         "get"={"security"="is_granted('ROLE_ADMIN_DOCUMENT_GERER_LIST')"},
 *         "post"={"security"="is_granted('ROLE_ADMIN_DOCUMENT_GERER_EDIT')"}
 *     },
 *     itemOperations={
 *         "get"={"security"="is_granted('ROLE_ADMIN_DOCUMENT_GERER_VIEW')"},
 *         "put"={"security"="is_granted('ROLE_ADMIN_DOCUMENT_GERER_EDIT')"},
 *     },
 *     normalizationContext={"groups"={"read"}},
 *     denormalizationContext={"groups"={"write"}}
 * )
 * @ORM\Entity
 * @ORM\HasLifecycleCallbacks()
 * @ORM\Table(name="document")
 */
class Document
{
    use EnablableEntityTrait,
        TimestampableEntity,
        NameSlugContentEntityTrait;

    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
    * @var \Application\Sonata\MediaBundle\Entity\Media
    * @Assert\NotBlank()
    * @ORM\ManyToOne(targetEntity="App\Application\Sonata\MediaBundle\Entity\Media", cascade={"persist"}, fetch="LAZY")
    * @ORM\JoinColumn(name="media_id", referencedColumnName="id")
    */
    protected $media;

    /**
     * @var User
     *
     * @ORM\ManyToOne(targetEntity="User", inversedBy="documents", cascade={"persist"})
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id", nullable=true)
     */
    private $user;

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return null|User
     */
    public function getUser(): ?User
    {
        return $this->user;
    }

    /**
     * @param null|User $user
     * @return $this
     */
    public function setUser(?User $user)
    {
        $this->user = $user;
        return $this;
    }

    /**
    * Get media
    * @return
    */
    public function getMedia()
    {
        return $this->media;
    }

    /**
    * Set media
    * @return $this
    */
    public function setMedia($media)
    {
        $this->media = $media;
        return $this;
    }

    public function __toString(): string
    {
        return $this->getTitle()?$this->getTitle():'Document';
    }
}
