<?php

namespace App\Controller;

use App\Entity\Prestataire;
use App\Entity\Rubrique;
use App\Entity\TransactionPrestataireAdherent;
use App\Entity\TypePrestataire;
use App\Form\Type\PrestataireInfosFormType;
use App\Form\Type\TransactionPrestataireAdherentFormType;
use Doctrine\ORM\EntityManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Routing\RouterInterface;

class PrestatairesController extends FrontController
{
    protected $em;
    private $router;

    public function __construct(EntityManagerInterface $em, RouterInterface $router)
    {
        $this->em = $em;
        $this->router = $router;
    }

    /**
     * @Route("/prestataire/{slug}", name="show_prestataire")
     */
    public function showPrestaAction(Prestataire $prestataire)
    {
        if (!$this->isFrontActivated()) {
            return $this->redirectToRoute('index');
        }
        if ($prestataire->isMlc()) {
            // Ne pas montrer la page du prestataire recevant les cotisations !
            return new RedirectResponse($this->router->generate('index'));
        }
        return $this->render('presta/show.html.twig', array(
            'presta' => $prestataire
        ));
    }

    /**
     * @Route("/prestataires/liste", name="liste_prestataire")
     */
    public function listePrestaAction()
    {
        if (!$this->isFrontActivated()) {
            return $this->redirectToRoute('index');
        }
        $type_presta = $this->em->getRepository(TypePrestataire::class)->findOneBy(array('slug' => 'prestataire'));
        $prestas = $this->em->getRepository(Prestataire::class)->findBy(array('enabled' => true, 'mlc' => false, 'typeprestataire' => $type_presta), array('raison' => 'ASC'));

        return $this->render('presta/liste_prestataires.html.twig', array(
            'prestas' => $prestas,
            'type' => 'Prestataires'
        ));
    }

    /**
     * @Route("/partenaires/liste", name="liste_partenaire")
     */
    public function listePartnerAction()
    {
        if (!$this->isFrontActivated()) {
            return $this->redirectToRoute('index');
        }
        $type_partner = $this->em->getRepository(TypePrestataire::class)->findOneBy(array('slug' => 'partenaire'));
        $partners = $this->em->getRepository(Prestataire::class)->findBy(array('enabled' => true, 'mlc' => false, 'typeprestataire' => $type_partner), array('raison' => 'ASC'));

        return $this->render('presta/liste_prestataires.html.twig', array(
            'prestas' => $partners,
            'type' => 'Partenaires'
        ));
    }

    /**
     * @Route("/prestataires/carte", name="carte_prestataire")
     */
    public function cartePrestaAction()
    {
        if (!$this->isFrontActivated()) {
            return $this->redirectToRoute('index');
        }
        $prestas = $this->em->getRepository(Prestataire::class)->findBy(array('enabled' => true), array('raison' => 'ASC'));

        return $this->render('presta/carte.html.twig', array(
            'prestas' => $prestas
        ));
    }

    /**
     * @Route("/prestataires/rubriques", name="rubriques_prestataire")
     */
    public function rubriquesAction()
    {
        if (!$this->isFrontActivated()) {
            return $this->redirectToRoute('index');
        }
        $rubriques = $this->em->getRepository(Rubrique::class)->findBy(array('enabled' => true), array('name' => 'ASC'));

        return $this->render('presta/rubriques.html.twig', array(
            'rubriques' => $rubriques
        ));
    }

    /**
     * @Route("/prestataires/rubrique/{slug}", name="show_rubrique")
     */
    public function showRubriqueAction(Rubrique $rubrique)
    {
        if (!$this->isFrontActivated()) {
            return $this->redirectToRoute('index');
        }
        return $this->render('presta/show_rubrique.html.twig', array(
            'rubrique' => $rubrique
        ));
    }
}
