<?php

namespace App\Twig;

use App\Entity\Groupe;
use App\Entity\Rubrique;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;
use Twig\TwigFunction;
use Twig\TwigTest;

class AppExtension extends AbstractExtension
{
    public $container;

    public function __construct($container)
    {
        $this->container = $container;
    }

    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction('getAllRubriques', array($this, 'getAllRubriques')),
            new \Twig_SimpleFunction('getAllGroupes', array($this, 'getAllGroupes')),
            new \Twig_SimpleFunction('parameter', function($name)
            {
                return $this->container->getParameter($name);
            })
        ];
    }

    public function getAllRubriques()
    {
        return $this->container->get('doctrine')->getRepository(Rubrique::class)->findBy(array('enabled' => true));
    }
    /**
     * Return a list of all filters.
     *
     * @return array
     */
    public function getFilters()
    {
        return [
            new \Twig_SimpleFilter('safe_email', [$this, 'safeEmailFilter']),
        ];
    }

    public function getAllGroupes()
    {
        return $this->container->get('doctrine')->getRepository(Groupe::class)->findBy(array('enabled' => true));
    }

    public function getTests(): array
    {
        return [
            new TwigTest('instanceof', [$this, 'instanceof']),
        ];
    }

    public function instanceof($var, $instance)
    {
        $reflexionClass = new \ReflectionClass($instance);
        return $reflexionClass->isInstance($var);
    }

    /**
     * Protects email address.
     * (inspired by : https://github.com/getgrav/grav/blob/develop/system/src/Grav/Common/Twig/TwigExtension.php )
     *
     * @param  string $str
     *
     * @return string
     */
    public function safeEmailFilter($str)
    {
        $email   = '';
        for ( $i = 0, $len = strlen( $str ); $i < $len; $i++ ) {
            $j = mt_rand( 0, 1);
            if ( $j === 0 ) {
                $email .= '&#' . ord( $str[$i] ) . ';';
            } elseif ( $j === 1 ) {
                $email .= $str[$i];
            }
        }
        return str_replace( '@', '&#64;', $email );
    }
}
