<?php

namespace App\Repository;

use App\Entity\Groupeprestataire;
use App\Entity\Prestataire;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method Prestataire|null find($id, $lockMode = null, $lockVersion = null)
 * @method Prestataire|null findOneBy(array $criteria, array $orderBy = null)
 * @method Prestataire[]    findAll()
 * @method Prestataire[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class PrestataireRepository extends ServiceEntityRepository
{
    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, Prestataire::class);
    }

   /**
    * @return Prestataire[] Returns an array of Prestataire objects
    */
    public function findByGroupeprestataire(Groupeprestataire $groupe)
    {
        $qb = $this->createQueryBuilder('p');
        return $qb
            ->where($qb->expr()->isMemberOf(':groupe', 'p.groupeprestataires'))
            ->andWhere('p.enabled = :enabled')
            ->setParameter('groupe', $groupe)
            ->setParameter('enabled', true)
            ->orderBy('p.raison', 'ASC')
            ->getQuery()
            ->getResult()
        ;
    }
}
