<?php declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20181123175337 extends AbstractMigration
{
    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE user (id INT AUTO_INCREMENT NOT NULL, user_id INT DEFAULT NULL, adherent INT DEFAULT NULL, prestataire INT DEFAULT NULL, username VARCHAR(180) NOT NULL, username_canonical VARCHAR(180) NOT NULL, email VARCHAR(180) NOT NULL, email_canonical VARCHAR(180) NOT NULL, enabled TINYINT(1) NOT NULL, salt VARCHAR(255) DEFAULT NULL, password VARCHAR(255) NOT NULL, last_login DATETIME DEFAULT NULL, confirmation_token VARCHAR(180) DEFAULT NULL, password_requested_at DATETIME DEFAULT NULL, roles LONGTEXT NOT NULL COMMENT \'(DC2Type:array)\', created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, date_of_birth DATETIME DEFAULT NULL, firstname VARCHAR(64) DEFAULT NULL, lastname VARCHAR(64) DEFAULT NULL, website VARCHAR(64) DEFAULT NULL, biography VARCHAR(1000) DEFAULT NULL, gender VARCHAR(1) DEFAULT NULL, locale VARCHAR(8) DEFAULT NULL, timezone VARCHAR(64) DEFAULT NULL, phone VARCHAR(64) DEFAULT NULL, facebook_uid VARCHAR(255) DEFAULT NULL, facebook_name VARCHAR(255) DEFAULT NULL, facebook_data LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:json)\', twitter_uid VARCHAR(255) DEFAULT NULL, twitter_name VARCHAR(255) DEFAULT NULL, twitter_data LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:json)\', gplus_uid VARCHAR(255) DEFAULT NULL, gplus_name VARCHAR(255) DEFAULT NULL, gplus_data LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:json)\', token VARCHAR(255) DEFAULT NULL, two_step_code VARCHAR(255) DEFAULT NULL, etat VARCHAR(50) DEFAULT NULL, mobile VARCHAR(15) DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, UNIQUE INDEX UNIQ_8D93D64992FC23A8 (username_canonical), UNIQUE INDEX UNIQ_8D93D649A0D96FBF (email_canonical), UNIQUE INDEX UNIQ_8D93D649C05FB297 (confirmation_token), UNIQUE INDEX UNIQ_8D93D649A76ED395 (user_id), UNIQUE INDEX UNIQ_8D93D64990D3F060 (adherent), UNIQUE INDEX UNIQ_8D93D64960A26480 (prestataire), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE news (id INT AUTO_INCREMENT NOT NULL, fichier_id INT DEFAULT NULL, user_id INT NOT NULL, visible_by_all_groups TINYINT(1) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, name VARCHAR(150) NOT NULL, slug VARCHAR(150) NOT NULL, content LONGTEXT DEFAULT NULL, enabled TINYINT(1) NOT NULL, deleted_at DATETIME DEFAULT NULL, UNIQUE INDEX UNIQ_1DD39950989D9B62 (slug), UNIQUE INDEX UNIQ_1DD39950F915CFE (fichier_id), INDEX IDX_1DD39950A76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE rubrique (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(150) NOT NULL, slug VARCHAR(150) NOT NULL, content LONGTEXT DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, UNIQUE INDEX UNIQ_8FA4097C989D9B62 (slug), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE rubrique_prestataire (rubrique_id INT NOT NULL, prestataire_id INT NOT NULL, INDEX IDX_7D4D41BB3BD38833 (rubrique_id), INDEX IDX_7D4D41BBBE3DB2B7 (prestataire_id), PRIMARY KEY(rubrique_id, prestataire_id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE cotisation (id INT AUTO_INCREMENT NOT NULL, type VARCHAR(12) NOT NULL, annee INT NOT NULL, debut DATE NOT NULL, fin DATE NOT NULL, montant NUMERIC(6, 2) NOT NULL, moyen VARCHAR(20) NOT NULL, recu TINYINT(1) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE document (id INT AUTO_INCREMENT NOT NULL, fichier_id INT DEFAULT NULL, user_id INT DEFAULT NULL, enabled TINYINT(1) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, name VARCHAR(150) NOT NULL, slug VARCHAR(150) NOT NULL, content LONGTEXT DEFAULT NULL, UNIQUE INDEX UNIQ_D8698A76989D9B62 (slug), UNIQUE INDEX UNIQ_D8698A76F915CFE (fichier_id), INDEX IDX_D8698A76A76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE transaction (id INT AUTO_INCREMENT NOT NULL, expediteur_id INT DEFAULT NULL, destinataire_id INT DEFAULT NULL, type VARCHAR(3) NOT NULL, montant NUMERIC(7, 2) NOT NULL, titre VARCHAR(255) DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, enabled TINYINT(1) NOT NULL, INDEX IDX_723705D110335F61 (expediteur_id), INDEX IDX_723705D1A4F84F6E (destinataire_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE typepresta (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(150) NOT NULL, slug VARCHAR(150) NOT NULL, content LONGTEXT DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, deleted_at DATETIME DEFAULT NULL, UNIQUE INDEX UNIQ_966F48A2989D9B62 (slug), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE siege (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(150) NOT NULL, slug VARCHAR(150) NOT NULL, content LONGTEXT DEFAULT NULL, compte NUMERIC(7, 2) NOT NULL, UNIQUE INDEX UNIQ_6706B4F7989D9B62 (slug), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE marche (id INT AUTO_INCREMENT NOT NULL, geoloc_id INT DEFAULT NULL, contact VARCHAR(100) NOT NULL, jour VARCHAR(255) NOT NULL, name VARCHAR(150) NOT NULL, slug VARCHAR(150) NOT NULL, content LONGTEXT DEFAULT NULL, enabled TINYINT(1) NOT NULL, tel VARCHAR(15) DEFAULT NULL, email VARCHAR(100) DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, UNIQUE INDEX UNIQ_BAA18ACC989D9B62 (slug), UNIQUE INDEX UNIQ_BAA18ACCEF390162 (geoloc_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE marche_prestataire (marche_id INT NOT NULL, prestataire_id INT NOT NULL, INDEX IDX_652F05189E494911 (marche_id), INDEX IDX_652F0518BE3DB2B7 (prestataire_id), PRIMARY KEY(marche_id, prestataire_id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE adherent (id INT AUTO_INCREMENT NOT NULL, user_id INT DEFAULT NULL, ecompte NUMERIC(7, 2) NOT NULL, UNIQUE INDEX UNIQ_90D3F060A76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE comptoir (id INT AUTO_INCREMENT NOT NULL, fichier_id INT DEFAULT NULL, groupe_id INT DEFAULT NULL, geoloc_id INT DEFAULT NULL, name VARCHAR(150) NOT NULL, slug VARCHAR(150) NOT NULL, content LONGTEXT DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, enabled TINYINT(1) NOT NULL, tel VARCHAR(15) DEFAULT NULL, email VARCHAR(100) DEFAULT NULL, compte NUMERIC(7, 2) NOT NULL, UNIQUE INDEX UNIQ_A6E2C35E989D9B62 (slug), UNIQUE INDEX UNIQ_A6E2C35EF915CFE (fichier_id), INDEX IDX_A6E2C35E7A45358C (groupe_id), UNIQUE INDEX UNIQ_A6E2C35EEF390162 (geoloc_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE charte (id INT AUTO_INCREMENT NOT NULL, image_id INT DEFAULT NULL, fichier_id INT DEFAULT NULL, name VARCHAR(150) NOT NULL, slug VARCHAR(150) NOT NULL, content LONGTEXT DEFAULT NULL, UNIQUE INDEX UNIQ_3484E5A6989D9B62 (slug), UNIQUE INDEX UNIQ_3484E5A63DA5256D (image_id), UNIQUE INDEX UNIQ_3484E5A6F915CFE (fichier_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE transfert (id INT AUTO_INCREMENT NOT NULL, operateur VARCHAR(20) NOT NULL, type VARCHAR(3) NOT NULL, expediteur VARCHAR(100) NOT NULL, destinataire VARCHAR(100) NOT NULL, montant NUMERIC(7, 2) NOT NULL, reference VARCHAR(255) DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, enabled TINYINT(1) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE lien (id INT AUTO_INCREMENT NOT NULL, user_id INT DEFAULT NULL, url VARCHAR(255) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, enabled TINYINT(1) NOT NULL, name VARCHAR(150) NOT NULL, slug VARCHAR(150) NOT NULL, content LONGTEXT DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, UNIQUE INDEX UNIQ_A532B4B5989D9B62 (slug), INDEX IDX_A532B4B5A76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE prestataire (id INT AUTO_INCREMENT NOT NULL, typeprestataire_id INT DEFAULT NULL, image_id INT DEFAULT NULL, user_id INT DEFAULT NULL, prestataire_group_id INT DEFAULT NULL, geoloc_id INT DEFAULT NULL, raison VARCHAR(100) NOT NULL, metier VARCHAR(100) NOT NULL, statut VARCHAR(50) DEFAULT NULL, responsable VARCHAR(200) DEFAULT NULL, iban VARCHAR(100) NOT NULL, siret VARCHAR(50) NOT NULL, web VARCHAR(255) DEFAULT NULL, accept TINYINT(1) NOT NULL, enabled TINYINT(1) NOT NULL, compte NUMERIC(7, 2) NOT NULL, deleted_at DATETIME DEFAULT NULL, UNIQUE INDEX UNIQ_60A26480618045AC (typeprestataire_id), UNIQUE INDEX UNIQ_60A264803DA5256D (image_id), UNIQUE INDEX UNIQ_60A26480A76ED395 (user_id), INDEX IDX_60A264803AA0FF34 (prestataire_group_id), UNIQUE INDEX UNIQ_60A26480EF390162 (geoloc_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE geoloc (id INT AUTO_INCREMENT NOT NULL, adresse VARCHAR(255) DEFAULT NULL, cpostal INT DEFAULT NULL, ville VARCHAR(100) DEFAULT NULL, lat NUMERIC(10, 7) DEFAULT NULL, lon NUMERIC(10, 7) DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE faq (id INT AUTO_INCREMENT NOT NULL, fichier_id INT DEFAULT NULL, user_id INT DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, enabled TINYINT(1) NOT NULL, UNIQUE INDEX UNIQ_E8FF75CCF915CFE (fichier_id), INDEX IDX_E8FF75CCA76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE page (id INT AUTO_INCREMENT NOT NULL, user_id INT NOT NULL, js LONGTEXT DEFAULT NULL, css LONGTEXT DEFAULT NULL, description VARCHAR(255) DEFAULT NULL, tag VARCHAR(255) DEFAULT NULL, template VARCHAR(255) DEFAULT NULL, name VARCHAR(150) NOT NULL, slug VARCHAR(150) NOT NULL, content LONGTEXT DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, enabled TINYINT(1) NOT NULL, UNIQUE INDEX UNIQ_140AB620989D9B62 (slug), INDEX IDX_140AB620A76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE groupe (id INT AUTO_INCREMENT NOT NULL, deleted_at DATETIME DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE message (id INT AUTO_INCREMENT NOT NULL, expediteur_id INT DEFAULT NULL, destinataire_id INT DEFAULT NULL, name VARCHAR(150) NOT NULL, slug VARCHAR(150) NOT NULL, content LONGTEXT DEFAULT NULL, enabled TINYINT(1) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, deleted_at DATETIME DEFAULT NULL, UNIQUE INDEX UNIQ_B6BD307F989D9B62 (slug), INDEX IDX_B6BD307F10335F61 (expediteur_id), INDEX IDX_B6BD307FA4F84F6E (destinataire_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE fichier (id INT AUTO_INCREMENT NOT NULL, path LONGTEXT DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, discr VARCHAR(255) NOT NULL, width INT DEFAULT NULL, height INT DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE usergroup (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(180) NOT NULL, roles LONGTEXT NOT NULL COMMENT \'(DC2Type:array)\', UNIQUE INDEX UNIQ_4A6478175E237E06 (name), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('ALTER TABLE user ADD CONSTRAINT FK_8D93D649A76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE user ADD CONSTRAINT FK_8D93D64990D3F060 FOREIGN KEY (adherent) REFERENCES adherent (id)');
        $this->addSql('ALTER TABLE user ADD CONSTRAINT FK_8D93D64960A26480 FOREIGN KEY (prestataire) REFERENCES prestataire (id)');
        $this->addSql('ALTER TABLE news ADD CONSTRAINT FK_1DD39950F915CFE FOREIGN KEY (fichier_id) REFERENCES fichier (id)');
        $this->addSql('ALTER TABLE news ADD CONSTRAINT FK_1DD39950A76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE rubrique_prestataire ADD CONSTRAINT FK_7D4D41BB3BD38833 FOREIGN KEY (rubrique_id) REFERENCES rubrique (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE rubrique_prestataire ADD CONSTRAINT FK_7D4D41BBBE3DB2B7 FOREIGN KEY (prestataire_id) REFERENCES prestataire (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE cotisation ADD CONSTRAINT FK_AE64D2EDBF396750 FOREIGN KEY (id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE document ADD CONSTRAINT FK_D8698A76F915CFE FOREIGN KEY (fichier_id) REFERENCES fichier (id)');
        $this->addSql('ALTER TABLE document ADD CONSTRAINT FK_D8698A76A76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE transaction ADD CONSTRAINT FK_723705D110335F61 FOREIGN KEY (expediteur_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE transaction ADD CONSTRAINT FK_723705D1A4F84F6E FOREIGN KEY (destinataire_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE marche ADD CONSTRAINT FK_BAA18ACCEF390162 FOREIGN KEY (geoloc_id) REFERENCES geoloc (id)');
        $this->addSql('ALTER TABLE marche_prestataire ADD CONSTRAINT FK_652F05189E494911 FOREIGN KEY (marche_id) REFERENCES marche (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE marche_prestataire ADD CONSTRAINT FK_652F0518BE3DB2B7 FOREIGN KEY (prestataire_id) REFERENCES prestataire (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE adherent ADD CONSTRAINT FK_90D3F060A76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE comptoir ADD CONSTRAINT FK_A6E2C35EF915CFE FOREIGN KEY (fichier_id) REFERENCES fichier (id)');
        $this->addSql('ALTER TABLE comptoir ADD CONSTRAINT FK_A6E2C35E7A45358C FOREIGN KEY (groupe_id) REFERENCES groupe (id)');
        $this->addSql('ALTER TABLE comptoir ADD CONSTRAINT FK_A6E2C35EEF390162 FOREIGN KEY (geoloc_id) REFERENCES geoloc (id)');
        $this->addSql('ALTER TABLE charte ADD CONSTRAINT FK_3484E5A63DA5256D FOREIGN KEY (image_id) REFERENCES fichier (id)');
        $this->addSql('ALTER TABLE charte ADD CONSTRAINT FK_3484E5A6F915CFE FOREIGN KEY (fichier_id) REFERENCES fichier (id)');
        $this->addSql('ALTER TABLE lien ADD CONSTRAINT FK_A532B4B5A76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE prestataire ADD CONSTRAINT FK_60A26480618045AC FOREIGN KEY (typeprestataire_id) REFERENCES typepresta (id)');
        $this->addSql('ALTER TABLE prestataire ADD CONSTRAINT FK_60A264803DA5256D FOREIGN KEY (image_id) REFERENCES fichier (id)');
        $this->addSql('ALTER TABLE prestataire ADD CONSTRAINT FK_60A26480A76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE prestataire ADD CONSTRAINT FK_60A264803AA0FF34 FOREIGN KEY (prestataire_group_id) REFERENCES groupe (id)');
        $this->addSql('ALTER TABLE prestataire ADD CONSTRAINT FK_60A26480EF390162 FOREIGN KEY (geoloc_id) REFERENCES geoloc (id)');
        $this->addSql('ALTER TABLE faq ADD CONSTRAINT FK_E8FF75CCF915CFE FOREIGN KEY (fichier_id) REFERENCES fichier (id)');
        $this->addSql('ALTER TABLE faq ADD CONSTRAINT FK_E8FF75CCA76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE page ADD CONSTRAINT FK_140AB620A76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE groupe ADD CONSTRAINT FK_4B98C21BF396750 FOREIGN KEY (id) REFERENCES siege (id)');
        $this->addSql('ALTER TABLE message ADD CONSTRAINT FK_B6BD307F10335F61 FOREIGN KEY (expediteur_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE message ADD CONSTRAINT FK_B6BD307FA4F84F6E FOREIGN KEY (destinataire_id) REFERENCES user (id)');
    }

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE user DROP FOREIGN KEY FK_8D93D649A76ED395');
        $this->addSql('ALTER TABLE news DROP FOREIGN KEY FK_1DD39950A76ED395');
        $this->addSql('ALTER TABLE cotisation DROP FOREIGN KEY FK_AE64D2EDBF396750');
        $this->addSql('ALTER TABLE document DROP FOREIGN KEY FK_D8698A76A76ED395');
        $this->addSql('ALTER TABLE transaction DROP FOREIGN KEY FK_723705D110335F61');
        $this->addSql('ALTER TABLE transaction DROP FOREIGN KEY FK_723705D1A4F84F6E');
        $this->addSql('ALTER TABLE adherent DROP FOREIGN KEY FK_90D3F060A76ED395');
        $this->addSql('ALTER TABLE lien DROP FOREIGN KEY FK_A532B4B5A76ED395');
        $this->addSql('ALTER TABLE prestataire DROP FOREIGN KEY FK_60A26480A76ED395');
        $this->addSql('ALTER TABLE faq DROP FOREIGN KEY FK_E8FF75CCA76ED395');
        $this->addSql('ALTER TABLE page DROP FOREIGN KEY FK_140AB620A76ED395');
        $this->addSql('ALTER TABLE message DROP FOREIGN KEY FK_B6BD307F10335F61');
        $this->addSql('ALTER TABLE message DROP FOREIGN KEY FK_B6BD307FA4F84F6E');
        $this->addSql('ALTER TABLE rubrique_prestataire DROP FOREIGN KEY FK_7D4D41BB3BD38833');
        $this->addSql('ALTER TABLE prestataire DROP FOREIGN KEY FK_60A26480618045AC');
        $this->addSql('ALTER TABLE groupe DROP FOREIGN KEY FK_4B98C21BF396750');
        $this->addSql('ALTER TABLE marche_prestataire DROP FOREIGN KEY FK_652F05189E494911');
        $this->addSql('ALTER TABLE user DROP FOREIGN KEY FK_8D93D64990D3F060');
        $this->addSql('ALTER TABLE user DROP FOREIGN KEY FK_8D93D64960A26480');
        $this->addSql('ALTER TABLE rubrique_prestataire DROP FOREIGN KEY FK_7D4D41BBBE3DB2B7');
        $this->addSql('ALTER TABLE marche_prestataire DROP FOREIGN KEY FK_652F0518BE3DB2B7');
        $this->addSql('ALTER TABLE marche DROP FOREIGN KEY FK_BAA18ACCEF390162');
        $this->addSql('ALTER TABLE comptoir DROP FOREIGN KEY FK_A6E2C35EEF390162');
        $this->addSql('ALTER TABLE prestataire DROP FOREIGN KEY FK_60A26480EF390162');
        $this->addSql('ALTER TABLE comptoir DROP FOREIGN KEY FK_A6E2C35E7A45358C');
        $this->addSql('ALTER TABLE prestataire DROP FOREIGN KEY FK_60A264803AA0FF34');
        $this->addSql('ALTER TABLE news DROP FOREIGN KEY FK_1DD39950F915CFE');
        $this->addSql('ALTER TABLE document DROP FOREIGN KEY FK_D8698A76F915CFE');
        $this->addSql('ALTER TABLE comptoir DROP FOREIGN KEY FK_A6E2C35EF915CFE');
        $this->addSql('ALTER TABLE charte DROP FOREIGN KEY FK_3484E5A63DA5256D');
        $this->addSql('ALTER TABLE charte DROP FOREIGN KEY FK_3484E5A6F915CFE');
        $this->addSql('ALTER TABLE prestataire DROP FOREIGN KEY FK_60A264803DA5256D');
        $this->addSql('ALTER TABLE faq DROP FOREIGN KEY FK_E8FF75CCF915CFE');
        $this->addSql('DROP TABLE user');
        $this->addSql('DROP TABLE news');
        $this->addSql('DROP TABLE rubrique');
        $this->addSql('DROP TABLE rubrique_prestataire');
        $this->addSql('DROP TABLE cotisation');
        $this->addSql('DROP TABLE document');
        $this->addSql('DROP TABLE transaction');
        $this->addSql('DROP TABLE typepresta');
        $this->addSql('DROP TABLE siege');
        $this->addSql('DROP TABLE marche');
        $this->addSql('DROP TABLE marche_prestataire');
        $this->addSql('DROP TABLE adherent');
        $this->addSql('DROP TABLE comptoir');
        $this->addSql('DROP TABLE charte');
        $this->addSql('DROP TABLE transfert');
        $this->addSql('DROP TABLE lien');
        $this->addSql('DROP TABLE prestataire');
        $this->addSql('DROP TABLE geoloc');
        $this->addSql('DROP TABLE faq');
        $this->addSql('DROP TABLE page');
        $this->addSql('DROP TABLE groupe');
        $this->addSql('DROP TABLE message');
        $this->addSql('DROP TABLE fichier');
        $this->addSql('DROP TABLE usergroup');
    }
}
