<?php

namespace App\Form\Type;

use App\Entity\Adherent;
use App\Entity\Prestataire;
use App\Entity\User;
use App\Enum\MoyenEnum;
use Doctrine\DBAL\Types\FloatType;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TransactionAdherentPrestataireFormType extends TransactionFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('expediteur', HiddenType::class, array(
                'data' => 1,//TODO : $this->tk->getToken()->getUser()->getAdherent()->getId(),
                'data_class' => null,
                'entity_class' => Adherent::class,
                'em' => $this->em
            ))
            ->add('destinataire', EntityType::class, array(
                'class' => Prestataire::class,
                'choices' =>  $this->em->getRepository(Prestataire::class)->findBy(array('enabled' => true)),
                'placeholder' => 'Prestataire',
                'required' => true,
                'label' => 'Prestataire :',
            ))
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'class' => '\App\Entity\TransactionAdherentPrestataire',
        ));
    }

    public function getParent()
    {
        return TransactionFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formTransactionAdherentPrestataire';
    }
}
