<?php

namespace App\Form\Type;

use App\Entity\User;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormError;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class RegistrationFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->remove('username')
            ->add('email', EmailType::class, array(
                'label' => 'form.email',
                'required' => true,
                'translation_domain' => 'FOSUserBundle'
            ))
            ->add('firstname', TextType::class, array(
                'label' => 'Prénom',
                'required' => false,
            ))
            ->add('lastname', TextType::class, array(
                'label' => 'Nom',
                'required' => false,
            ))
            ->add('plainPassword', RepeatedType::class, array(
                'type' => PasswordType::class,
                'options' => array(
                    'translation_domain' => 'FOSUserBundle',
                    'attr' => array(
                        'autocomplete' => 'new-password',
                    ),
                ),
                'first_options' => array('label' => 'form.password'),
                'second_options' => array('label' => 'form.password_confirmation'),
                'invalid_message' => 'fos_user.password.mismatch',
            ))
            ->addEventListener(FormEvents::POST_SUBMIT, function (FormEvent $event) use ($builder) {
                $repo = $this->em->getRepository(User::class);
                $emailExist = $repo->findBy(array('email' => $event->getForm()->get('email')->getData()));
                if (count($emailExist) > 0) {
                    $event->getForm()->get('email')->addError(new FormError('form.error.email_used'));
                }
            })
        ;
    }

    public function getParent()
    {
        return 'FOS\UserBundle\Form\Type\RegistrationFormType';
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'cascade_validation' => true,
            // 'type' => null
        ));
    }

    public function getBlockPrefix()
    {
        return 'app_user_registration';
    }
}
