<?php

namespace App\Form\Type;

use App\Entity\Geoloc;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class GeolocFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('adresse', TextType::class, array(
                'label' => 'Addresse :',
                'required' => false
            ))
            ->add('cpostal', TextType::class, array(
                'label' => 'Code postal :',
                'required' => false
            ))
            ->add('ville', TextType::class, array(
                'label' => 'Ville :',
                'required' => false
            ))
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Geoloc::class
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formGeoloc';
    }
}
