<?php

namespace App\Form\Type;

use App\Entity\User;
use App\Enum\MoyenEnum;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;

class FluxFormType extends AbstractType
{
    protected $em;
    protected $tk;

    public function __construct(EntityManagerInterface $em, TokenStorageInterface $tk)
    {
        $this->em = $em;
        $this->tk = $tk;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('operateur', HiddenType::class, array(
                'data' => $this->tk->getToken()->getUser()->getId(),
                'data_class' => null,
                'entity_class' => User::class,
                'em' => $this->em
            ))
            ->add('montant', MoneyType::class, array(
                'label' => 'Montant :',
                'required' => true,
            ))
            ->add('moyen', ChoiceType::class, array(
                'required' => true,
                'choices' => MoyenEnum::getAvailableTypes(),
                'choice_label' => function ($choice) {
                    return MoyenEnum::getTypeName($choice);
                },
            ))
            ->add('reference', TextType::class, array(
                'label' => 'Reference :',
                'required' => true
            ))
        ;
    }

    public function getBlockPrefix()
    {
        return 'formFlux';
    }
}
