<?php

namespace App\Form\Type;

use App\Entity\Adherent;
use App\Entity\Groupe;
use App\Entity\Prestataire;
use App\Entity\User;
use App\Enum\MoyenEnum;
use App\Form\Type\CotisationFormType;
use App\Form\Type\GeolocFormType;
use App\Form\Type\RegistrationFormType;
use Doctrine\DBAL\Types\FloatType;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\DependencyInjection\ContainerAwareTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;

class AdhererFormType extends AbstractType
{
    protected $container;
    protected $em;
    protected $tk;

    public function __construct(ContainerInterface $container, EntityManagerInterface $em, TokenStorageInterface $tk)
    {
        $this->container = $container;
        $this->em = $em;
        $this->tk = $tk;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('user', RegistrationFormType::class, array(
                'label' => false,
                'required' => false
            ))
            ->add('groupe', ChoiceType::class, array(
                'required' => true,
                'label' => 'GROUPE LOCAL',
                'choices' => $this->container->get('doctrine')->getRepository(Groupe::class)->findAll(),
                'choice_label' => 'name',
                'placeholder' => 'Choisir un groupe',
            ))
            ->add('geoloc', GeolocFormType::class, array(
                'label' => 'ADRESSE',
                'required' => false
            ))
            ->add('cotisation', CotisationFormType::class, array(
                'label' => 'COTISATION',
                'required' => false
            ))
            ->add('save', SubmitType::class, ['label' => "Valider l'adhésion"])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Adherent::class,
            'cascade_validation' => true
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formAdherer';
    }
}
