<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TRANSACTION
 *   - ADHERENTS        =>    PRESTATAIRES      (Paiement numérique)
 *
 * @ORM\Entity
 */
class TransactionAdherentPrestataire extends Transaction
{
    /**
     * @ORM\OneToOne(targetEntity="Adherent")
     * @ORM\JoinColumn(name="adherent_id", referencedColumnName="id", nullable=true)
     */
    protected $expediteur;

    /**
     * @ORM\OneToOne(targetEntity="Prestataire")
     * @ORM\JoinColumn(name="prestataire_id", referencedColumnName="id", nullable=true)
     */
    protected $destinataire;

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'adherent_prestataire';
    }
}
