<?php

namespace App\Entity;

use App\Entity\EntityTrait\EnablableEntityTrait;
use App\Entity\EntityTrait\GeolocEntityTrait;
use App\Entity\EntityTrait\HasCompteEntity;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Gedmo\Mapping\Annotation\Slug;
use Gedmo\Timestampable\Traits\TimestampableEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity(repositoryClass="App\Repository\PrestataireRepository")
 * @ORM\Table(name="prestataire")
 */
class Prestataire
{
    use EnablableEntityTrait,
        TimestampableEntity,
        GeolocEntityTrait,
        HasCompteEntity;

    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\Column(name="id", type="integer")
     * @ORM\GeneratedValue
     */
    protected $id;

    /**
     * @var string
     *
     * @ORM\Column(name="raison", type="string", length=100)
     */
    private $raison;

    /**
     * @var string|null
     *
     * @Gedmo\Slug(fields={"raison"})
     * @ORM\Column(length=100, unique=true)
     */
    protected $slug;

    /**
     * @var string
     *
     * @ORM\Column(name="metier", type="string", length=100)
     */
    private $metier;

    /**
     * @var null|string
     *
     * @ORM\Column(name="statut", type="string", length=50, nullable=true)
     */
    private $statut;

    /**
     * @var null|string
     *
     * @ORM\Column(name="responsable", type="string", length=200, nullable=true)
     */
    private $responsable;

    /**
     * @var string
     *
     * @ORM\Column(name="iban", type="string", length=100)
     */
    private $iban;

    /**
     * @var string
     *
     * @ORM\Column(name="siret", type="string", length=50)
     */
    private $siret;

    /**
     * @var null|string
     *
     * @ORM\Column(name="web", type="string", length=255, nullable=true)
     */
    private $web;

    /**
     * @var bool
     *
     * @ORM\Column(name="accept", type="boolean", nullable=false)
     */
    private $accept = false;

    /**
     * @var bool
     *
     * @ORM\Column(name="partenaire", type="boolean", nullable=false)
     */
    private $partenaire = false;


    /**
     * @var null|string (champ libre)
     *
     * @ORM\Column(name="horaires", type="string", length=255, nullable=true)
     */
    private $horaires;

    /**
     * @var TypePrestataire
     *
     * @ORM\ManyToOne(targetEntity="TypePrestataire", cascade={"persist"}, inversedBy="prestataires")
     */
    private $typeprestataire;

    /**
     * @var ArrayCollection|Rubrique[]
     * @ORM\ManyToMany(targetEntity="Rubrique", mappedBy="prestataires", cascade={"persist"}, fetch="EXTRA_LAZY")
     * @ORM\JoinTable(name="rubrique_prestataire")
     */
    private $rubriques;

    /**
    * @var \Application\Sonata\MediaBundle\Entity\Media
    * @ORM\ManyToOne(targetEntity="App\Application\Sonata\MediaBundle\Entity\Media", cascade={"persist"}, fetch="LAZY")
    * @ORM\JoinColumn(name="media_id", referencedColumnName="id", nullable=true)
    */
    protected $media;

   /**
     * @var User
     *
     * @ORM\OneToOne(targetEntity="User", cascade={"all"}, mappedBy="prestataire", fetch="LAZY")
     */
    protected $user;

    /**
     * @var Groupe $groupe
     *
     * @ORM\ManyToOne(targetEntity="App\Entity\Groupe", inversedBy="prestataires")
     */
    private $groupe;

    /**
     * @var ArrayCollection|Amap/Marché[]
     * @ORM\ManyToMany(targetEntity="Groupeprestataire", mappedBy="prestataires", fetch="EXTRA_LAZY")
     * @ORM\JoinTable(name="groupes_prestataires")
     */
    private $groupeprestataires;


    public function __construct()
    {
        $this->users = new ArrayCollection();
        $this->groupeprestataires = new ArrayCollection();
        $this->rubriques = new ArrayCollection();
    }

    /**
     * @return mixed
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getRaison(): ?string
    {
        return $this->raison;
    }

    /**
     * @param string $raison
     * @return Prestataire
     */
    public function setRaison(string $raison)
    {
        $this->raison = $raison;
        return $this;
    }

    public function getSlug(): ?string
    {
        return $this->slug;
    }

    public function setSlug(?string $slug)
    {
        $this->slug = $slug;
        return $this;
    }

    /**
     * @return string
     */
    public function getMetier(): ?string
    {
        return $this->metier;
    }

    /**
     * @param string $metier
     * @return Prestataire
     */
    public function setMetier(string $metier)
    {
        $this->metier = $metier;
        return $this;
    }

    /**
     * @return null|string
     */
    public function getStatut(): ?string
    {
        return $this->statut;
    }

    /**
     * @param null|string $statut
     * @return Prestataire
     */
    public function setStatut(?string $statut)
    {
        $this->statut = $statut;
        return $this;
    }

    /**
     * @return null|string
     */
    public function getResponsable(): ?string
    {
        return $this->responsable;
    }

    /**
     * @param null|string $responsable
     * @return Prestataire
     */
    public function setResponsable(?string $responsable)
    {
        $this->responsable = $responsable;
        return $this;
    }

    /**
     * @return string
     */
    public function getIban(): ?string
    {
        return $this->iban;
    }

    /**
     * @param string $iban
     * @return Prestataire
     */
    public function setIban(string $iban)
    {
        $this->iban = $iban;
        return $this;
    }

    /**
     * @return string
     */
    public function getSiret(): ?string
    {
        return $this->siret;
    }

    /**
     * @param string $siret
     * @return Prestataire
     */
    public function setSiret(string $siret)
    {
        $this->siret = $siret;
        return $this;
    }

    /**
     * @return null|string
     */
    public function getWeb(): ?string
    {
        return $this->web;
    }

    /**
     * @param null|string $web
     * @return Prestataire
     */
    public function setWeb(?string $web)
    {
        $this->web = $web;
        return $this;
    }

    /**
     * @return bool
     */
    public function isAccept(): bool
    {
        return $this->accept;
    }

    /**
     * @param bool $accept
     * @return Prestataire
     */
    public function setAccept(bool $accept)
    {
        $this->accept = $accept;
        return $this;
    }

    /**
     * @return bool
     */
    public function isPartenaire(): bool
    {
        return $this->partenaire;
    }

    /**
     * @param bool $partenaire
     * @return Prestataire
     */
    public function setPartenaire(bool $partenaire)
    {
        $this->partenaire = $partenaire;
        return $this;
    }

    /**
     * @return User
     */
    public function getUser(): ?User
    {
        return $this->user;
    }

    /**
     * @param User $user
     * @return Prestataire
     */
    public function setUser(User $user): self
    {
        $this->user = $user;
        return $this;
    }

    /**
     * @param null|Groupe $groupe
     * @return $this
     */
    public function setGroupe(?Groupe $groupe)
    {
        $this->groupe = $groupe;
        return $this;
    }

    /**
     * @return null|Groupe
     */
    public function getGroupe(): ?Groupe
    {
        return $this->groupe;
    }

    /**
    * Get typeprestataire
    * @return
    */
    public function getTypeprestataire()
    {
        return $this->typeprestataire;
    }

    /**
    * Set typeprestataire
    * @return $this
    */
    public function setTypeprestataire($typeprestataire)
    {
        $this->typeprestataire = $typeprestataire;
        return $this;
    }

    /**
     * @return Rubrique[]|ArrayCollection
     */
    public function getRubriques()
    {
        return $this->rubriques;
    }

    /**
     * @param Rubrique $rubrique
     * @return $this
     */
    public function addRubrique(Rubrique $rubrique)
    {
        if (!$this->rubriques->contains($rubrique)) {
            $this->rubriques[] = $rubrique;
            $rubrique->addPrestataire($this);
        }
        return $this;
    }

    /**
     * @param Rubrique $rubrique
     * @return $this
     */
    public function removeRubrique(Rubrique $rubrique)
    {
        if ($this->rubriques->contains($rubrique)) {
            $this->rubriques->removeElement($rubrique);
            $rubrique->removePrestataire($this);
        }
        return $this;
    }

    /**
     * @return Amap[]|ArrayCollection
     */
    public function getGroupeprestataires()
    {
        return $this->groupeprestataires;
    }

    /**
     * @param Amap $amap
     * @return $this
     */
    public function addGroupeprestataire(Groupeprestataire $groupeprestataire)
    {
        if (!$this->groupeprestataires->contains($groupeprestataire)) {
            $this->groupeprestataires[] = $groupeprestataire;
            $groupeprestataire->addPrestataire($this);
        }
        return $this;
    }

    /**
     * @param Amap $amap
     * @return $this
     */
    public function removeGroupeprestataire(Groupeprestataire $groupeprestataires)
    {
        if ($this->groupeprestataires->contains($groupeprestataire)) {
            $this->groupeprestataires->removeElement($groupeprestataire);
            $groupeprestataire->removePrestataire($this);
        }
        return $this;
    }

    /**
    * Get horaires
    * @return string Horaires
    */
    public function getHoraires(): ?string
    {
        return $this->horaires;
    }

    /**
    * Set horaires
    * @return $this
    */
    public function setHoraires($horaires): self
    {
        $this->horaires = $horaires;
        return $this;
    }

    /**
    * Get media
    * @return
    */
    public function getMedia()
    {
        return $this->media;
    }

    /**
    * Set media
    * @return $this
    */
    public function setMedia($media)
    {
        $this->media = $media;
        return $this;
    }

    public function __toString(): string
    {
        return ($this->raison?$this->raison:($this->getUser()?$this->getUser()->getFullname():'Prestataire'));
    }
}
